package org.jeecg.modules.iost.basedata.controller;

import java.io.UnsupportedEncodingException;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.jeecg.common.system.vo.DictModel;
import org.jeecg.common.system.vo.LoginUser;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.dto.message.MessageDTO;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.iost.basedata.entity.IostReceivinglist;
import org.jeecg.modules.iost.basedata.entity.IostDeliveryNote;
import org.jeecg.modules.iost.basedata.entity.IostDeliveryNoteList;
import org.jeecg.modules.iost.basedata.entity.IostInsurancePolicyList;
import org.jeecg.modules.iost.basedata.entity.IostReceiving;
import org.jeecg.modules.iost.basedata.vo.IostReceivingOV;
import org.jeecg.modules.iost.basedata.vo.IostReceivingPage;
import org.jeecg.modules.iost.basedata.vo.PackageMaterialsPage;
import org.jeecg.modules.iost.basedata.vo.PackageMaterialsResult;
import org.jeecg.modules.iost.basedata.vo.PackageMaterialsVO;
import org.jeecg.modules.system.service.ISysDictService;
import org.jeecg.modules.iost.basedata.service.IIostReceivingService;
import org.jeecg.modules.iost.basedata.service.IIostReceivinglistService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;

 /**
 * @Description: 入仓单
 * @Author: jeecg-boot
 * @Date:   2020-11-16
 * @Version: V1.0
 */
@Api(tags="入仓单")
@RestController
@RequestMapping("/basedata/iostReceiving")
@Slf4j
public class IostReceivingController {
	@Autowired
	private ISysDictService sysDictService;
	@Autowired
	private IIostReceivingService iostReceivingService;
	@Autowired
	private IIostReceivinglistService iostReceivinglistService;
	
	/**
	 * 分页列表查询
	 *
	 * @param iostReceiving
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	@AutoLog(value = "入仓单-分页列表查询")
	@ApiOperation(value="入仓单-分页列表查询", notes="入仓单-分页列表查询")
	@GetMapping(value = "/list")
	public Result<?> queryPageList(IostReceiving iostReceiving,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<IostReceiving> queryWrapper = QueryGenerator.initQueryWrapper(iostReceiving, req.getParameterMap());
		Page<IostReceiving> page = new Page<IostReceiving>(pageNo, pageSize);
		Page<IostReceivingOV> pageOV = new Page<IostReceivingOV>(pageNo, pageSize);
		List<IostReceivingOV> listOV = new ArrayList<IostReceivingOV>();
		pageOV.setRecords(listOV);
		

		String[] params = "iost_storage,name,id".split(",");
		List<DictModel> ls = sysDictService.queryTableDictItemsByCode(params[0],params[1],params[2]);
		HashMap<String, String> idNameDic = new HashMap<String, String>();
		for(DictModel dictModel:ls) {
			if(idNameDic.containsKey(dictModel.getValue())) continue;
			idNameDic.put(dictModel.getValue(), dictModel.getText());
		}
		
		IPage<IostReceiving> pageList = iostReceivingService.page(page, queryWrapper);
		for(IostReceiving sIostReceiving: pageList.getRecords())
		{
			IostReceivingOV iostReceivingOV = new IostReceivingOV(sIostReceiving);
			listOV.add(iostReceivingOV);
			String id = iostReceivingOV.getWarehouseName();
			if(!idNameDic.containsKey(id)) continue;
			iostReceivingOV.setStorgeName(idNameDic.getOrDefault(id, ""));
		}
		pageOV.setCurrent(pageList.getCurrent());
		pageOV.setPages(pageList.getPages());
		pageOV.setSize(pageList.getSize());
		pageOV.setTotal(pageList.getTotal());
		
		return Result.OK(pageOV);
	}
	
	

	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "保险明细通过主表ID查询")
	@ApiOperation(value="保险明细主表ID查询", notes="保险明细-通主表ID查询")
	@GetMapping(value = "/queryIostReceivingIostReceivingListByMainId")
	public Result<?> queryIostReceivingIostReceivingListByMainId(@RequestParam(name="id",required=true) String id) {
		List<IostReceivinglist> iostIostReceivinglistList = iostReceivinglistService.selectByMainId(id);
		addSumRow(iostIostReceivinglistList);
		return Result.OK(iostIostReceivinglistList);
	}
	
	/***
	 * 增加统计行
	 * @param iostIostReceivinglistList
	 */
	private void addSumRow(List<IostReceivinglist> iostIostReceivinglistList)
	{
		int totleCases = 0;
		int totlePackagesTotal = 0;
		double totleVolumeTotal = 0;
		double totleWeightTotal = 0;
		double totleMoney = 0;
		for(IostReceivinglist iostReceivinglist: iostIostReceivinglistList)
		{
			totleCases = totleCases + iostReceivinglist.getCases();
			totlePackagesTotal = totlePackagesTotal + iostReceivinglist.getPackagesTotal();
			totleVolumeTotal = totleVolumeTotal + iostReceivinglist.getVolumeTotal();
			totleWeightTotal = totleWeightTotal + iostReceivinglist.getWeightTotal();
			totleMoney = totleMoney + iostReceivinglist.getMoney();
		}
		IostReceivinglist curIostReceivinglist = new IostReceivinglist();
		curIostReceivinglist.setNameChs("总和");
		curIostReceivinglist.setCases(totleCases);
		curIostReceivinglist.setPackagesTotal(totlePackagesTotal);
		curIostReceivinglist.setVolumeTotal(totleVolumeTotal);
		curIostReceivinglist.setWeightTotal(totleWeightTotal);
		curIostReceivinglist.setMoney(totleMoney);
		iostIostReceivinglistList.add(curIostReceivinglist);
	}
	
	
	/**
	 *   添加
	 *
	 * @param iostReceivingPage
	 * @return
	 */
	@AutoLog(value = "入仓单-添加")
	@ApiOperation(value="入仓单-添加", notes="入仓单-添加")
	@PostMapping(value = "/add")
	public Result<?> add(@RequestBody IostReceivingPage iostReceivingPage) {
		this.sum(iostReceivingPage);
		IostReceiving iostReceiving = new IostReceiving();
		BeanUtils.copyProperties(iostReceivingPage, iostReceiving);
		iostReceivingService.saveMain(iostReceiving, iostReceivingPage.getIostReceivinglistList());
		return Result.OK("添加成功！");
	}
	
	private void sum(IostReceivingPage iostReceivingPage)
	{
		List<IostReceivinglist> iostReceivingLists = iostReceivingPage.getIostReceivinglistList();
		iostReceivingPage.setVolumesTotal(0.0);
		iostReceivingPage.setWeightsTotal(0.0);
		
		for(IostReceivinglist iostReceivinglist:iostReceivingLists)
		{
			double volumesTotal = 0;
			if(iostReceivingPage.getVolumesTotal() != null)
			{
				volumesTotal = iostReceivingPage.getVolumesTotal();
			}
			double weightsTotal = 0;
			if(iostReceivingPage.getWeightsTotal() != null)
			{
				weightsTotal = iostReceivingPage.getWeightsTotal();
			}
			
			double singleVolumeTotal = 0;
			if(iostReceivinglist.getVolumeTotal() != null)
			{
				singleVolumeTotal = iostReceivinglist.getVolumeTotal();
			}

			double singleWeightsTotal = 0;
			if(iostReceivinglist.getWeightTotal() != null)
			{
				singleWeightsTotal = iostReceivinglist.getWeightTotal();
			}
			iostReceivingPage.setVolumesTotal(volumesTotal + singleVolumeTotal);
			iostReceivingPage.setWeightsTotal(weightsTotal + singleWeightsTotal);
		}
	}
	/**
	 *  编辑
	 *
	 * @param packageMaterialsPage
	 * @return
	 */
	@AutoLog(value = "入仓单-获取组装相关信息")
	@ApiOperation(value="入仓单-获取组装相关信息", notes="入仓单-获取组装相关信息")
	@PostMapping(value = "/getPackageMaterials")
	public Result<?> getPackageMaterials(@RequestBody PackageMaterialsPage packageMaterialsPage)
	{
		List<PackageMaterialsVO> packageMaterialsVOs = packageMaterialsPage.getPackageMaterialsVOs();
		List<String> ids = new ArrayList<String>();
		HashMap<String, PackageMaterialsVO> entryFlagDic = new HashMap<String, PackageMaterialsVO>();
		HashMap<String, HashMap<Integer, PackageMaterialsVO>> packageFlagDic = new HashMap<String, HashMap<Integer, PackageMaterialsVO>>();
		HashMap<String, HashSet<Integer>> packageMaterialMap = new HashMap<String, HashSet<Integer>>();
		for(PackageMaterialsVO packageMaterialsVO: packageMaterialsVOs)
		{
			entryFlagDic.put(packageMaterialsVO.getEntryId(), packageMaterialsVO);
			String id = packageMaterialsVO.getId();
			if(id == null || id.isEmpty()) continue;
			ids.add(id);
			Integer packaeFlag = packageMaterialsVO.getPackageFlag();
			if(packaeFlag == null || packaeFlag <= 0) continue;
			HashSet<Integer> packages = packageMaterialMap.getOrDefault(id, new HashSet<Integer>());
			HashMap<Integer, PackageMaterialsVO> curPackageFlagDic = packageFlagDic.getOrDefault(id, new HashMap<Integer, PackageMaterialsVO>());
			if(curPackageFlagDic.size() == 0)
			{
				packageFlagDic.put(id, curPackageFlagDic);
			}
			if(packageMaterialsVO.getCasesActual() != null && !packageFlagDic.containsKey(packaeFlag))
			{
				curPackageFlagDic.put(packaeFlag, packageMaterialsVO);
			}
			if(packages.size() == 0);
			{
				packageMaterialMap.put(id, packages);
			}
			packages.add(packaeFlag);
		}

		HashMap<String, IostReceiving> iostReceivingMap = new HashMap<String, IostReceiving>();
    	QueryWrapper<IostReceiving> iostReceivingQueryWrapper = new QueryWrapper<>();
    	iostReceivingQueryWrapper.in("id", ids);
    	List<IostReceiving> iostReceivings = iostReceivingService.list(iostReceivingQueryWrapper);
    	for(IostReceiving iostReceiving: iostReceivings)
    	{
    		iostReceivingMap.put(iostReceiving.getId(), iostReceiving);
    	}

    	List<PackageMaterialsResult> packageMaterialsResults = new ArrayList<PackageMaterialsResult>();
    	QueryWrapper<IostReceivinglist> iostReceivingListQueryWrapper = new QueryWrapper<>();
    	iostReceivingListQueryWrapper.in("receiving_id", ids);
    	List<IostReceivinglist> iostReceivinglists = iostReceivinglistService.list(iostReceivingListQueryWrapper);
    	for(IostReceivinglist iostReceivinglist:iostReceivinglists)
    	{
    		String receivingId = iostReceivinglist.getReceivingId();
    		IostReceiving iostReceiving = iostReceivingMap.getOrDefault(receivingId, null);
    		String entryId = iostReceivinglist.getId();
    		if(iostReceiving == null) continue;
    		HashSet<Integer> packageFlags = packageMaterialMap.getOrDefault(receivingId, new HashSet<Integer>());
    		Integer packageFlag = iostReceivinglist.getPackageFlag();
    		if((packageFlag == null) && !entryFlagDic.containsKey(entryId)) continue;
    		if(packageFlag != null && !packageFlags.contains(packageFlag)) continue;
    		
    		PackageMaterialsVO packageMaterialsVO = entryFlagDic.get(entryId);
    		if(packageFlagDic.containsKey(receivingId)) 
    		{
        		HashMap<Integer, PackageMaterialsVO> packageMaterialsVODic = packageFlagDic.get(receivingId);
        		if(packageFlag != null && packageMaterialsVODic.containsKey(packageFlag))
        		{
        			packageMaterialsVO = packageMaterialsVODic.get(packageFlag);
        		}
    		}
    		
    		PackageMaterialsResult packageMaterialsResult = new PackageMaterialsResult();
    		BeanUtils.copyProperties(iostReceiving, packageMaterialsResult);
    		BeanUtils.copyProperties(iostReceivinglist, packageMaterialsResult);
    		int actualCases = packageMaterialsVO.getCasesActual();
    		
    		if(iostReceivinglist.getPackages() != null)
    		{
    			packageMaterialsResult.setPackagesTotal(iostReceivinglist.getPackages() * actualCases);
    		}
    		if(iostReceivinglist.getVolume() != null)
    		{
    			packageMaterialsResult.setVolumeTotal(iostReceivinglist.getVolume() * actualCases);
    			if(iostReceivinglist.getPrice() != null)
    			{
    				packageMaterialsResult.setMoney(iostReceivinglist.getVolume() * iostReceivinglist.getPrice() * actualCases);
    			}
    		}
    		
    		if(iostReceivinglist.getWeight() != null)
    		{
    			packageMaterialsResult.setWeightTotal(iostReceivinglist.getWeight() * actualCases);
    		}
    		
    		packageMaterialsResult.setSourceId(receivingId);
    		packageMaterialsResult.setSourceEntryId(iostReceivinglist.getId());
    		if(entryFlagDic.containsKey(entryId))
    		{
    			packageMaterialsResult.setCasesActual(actualCases);
    		}
    		
    		packageMaterialsResults.add(packageMaterialsResult);
    	}

		return Result.OK(packageMaterialsResults);
	}
	
	/**
	 *  编辑
	 *
	 * @param iostReceivingPage
	 * @return
	 */
	@AutoLog(value = "入仓单-编辑")
	@ApiOperation(value="入仓单-编辑", notes="入仓单-编辑")
	@PutMapping(value = "/edit")
	public Result<?> edit(@RequestBody IostReceivingPage iostReceivingPage) {
		this.sum(iostReceivingPage);
		IostReceiving iostReceiving = new IostReceiving();
		BeanUtils.copyProperties(iostReceivingPage, iostReceiving);
		IostReceiving iostReceivingEntity = iostReceivingService.getById(iostReceiving.getId());
		if(iostReceivingEntity==null) {
			return Result.error("未找到对应数据");
		}
		
		List<IostReceivinglist> iostReceivinglists = iostReceivinglistService.selectByMainId(iostReceiving.getId());
		HashMap<String, IostReceivinglist> receivingListDic = new HashMap<String, IostReceivinglist>();
		for(IostReceivinglist iostReceivinglist:iostReceivinglists)
		{
			receivingListDic.put(iostReceivinglist.getId(), iostReceivinglist);
		}
		iostReceivinglists = iostReceivingPage.getIostReceivinglistList();
		for(IostReceivinglist iostReceivinglist:iostReceivinglists)
		{
			String id = iostReceivinglist.getId();
			if(!receivingListDic.containsKey(id)) continue;
			
			IostReceivinglist dbiostReceivinglist = receivingListDic.get(id);
			iostReceivinglist.setRefCases(dbiostReceivinglist.getRefCases());
		}

		iostReceivingService.updateMain(iostReceiving, iostReceivinglists);
		return Result.OK("编辑成功!");
	}
	
	/**
	 *   通过id删除
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "入仓单-通过id删除")
	@ApiOperation(value="入仓单-通过id删除", notes="入仓单-通过id删除")
	@DeleteMapping(value = "/delete")
	public Result<?> delete(@RequestParam(name="id",required=true) String id) {
		iostReceivingService.delMain(id);
		return Result.OK("删除成功!");
	}
	
	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "入仓单-批量删除")
	@ApiOperation(value="入仓单-批量删除", notes="入仓单-批量删除")
	@DeleteMapping(value = "/deleteBatch")
	public Result<?> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.iostReceivingService.delBatchMain(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功！");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "入仓单-通过id查询")
	@ApiOperation(value="入仓单-通过id查询", notes="入仓单-通过id查询")
	@GetMapping(value = "/queryById")
	public Result<?> queryById(@RequestParam(name="id",required=true) String id) {
		IostReceiving iostReceiving = iostReceivingService.getById(id);
		if(iostReceiving==null) {
			return Result.error("未找到对应数据");
		}
		return Result.OK(iostReceiving);

	}

	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "入仓单-通过id查询")
	@ApiOperation(value="入仓单-通过id查询", notes="入仓单-通过id查询")
	@GetMapping(value = "/queryByIdPrint")
	public Result<?> queryByIdPrint(@RequestParam(name="id",required=true) String id) {
		IostReceiving iostReceiving = iostReceivingService.getByIdPrint(id);
		if(iostReceiving==null) {
			return Result.error("未找到对应数据");
		}
		return Result.OK(iostReceiving);

	}
	
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "入仓列表通过主表ID查询")
	@ApiOperation(value="入仓列表主表ID查询", notes="入仓列表-通主表ID查询")
	@GetMapping(value = "/queryIostReceivinglistByMainId")
	public Result<?> queryIostReceivinglistListByMainId(@RequestParam(name="id",required=true) String id) {
		List<IostReceivinglist> iostReceivinglistList = iostReceivinglistService.selectByMainId(id);
		return Result.OK(iostReceivinglistList);
	}

    /**
    * 导出excel
    *
    * @param request
    * @param iostReceiving
    */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, IostReceiving iostReceiving) {
      // Step.1 组装查询条件查询数据
      QueryWrapper<IostReceiving> queryWrapper = QueryGenerator.initQueryWrapper(iostReceiving, request.getParameterMap());
      LoginUser sysUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();

      //Step.2 获取导出数据
      List<IostReceiving> queryList = iostReceivingService.list(queryWrapper);
      // 过滤选中数据
      String selections = request.getParameter("selections");
      List<IostReceiving> iostReceivingList = new ArrayList<IostReceiving>();
      if(oConvertUtils.isEmpty(selections)) {
          iostReceivingList = queryList;
      }else {
          List<String> selectionList = Arrays.asList(selections.split(","));
          iostReceivingList = queryList.stream().filter(item -> selectionList.contains(item.getId())).collect(Collectors.toList());
      }

      // Step.3 组装pageList
      List<IostReceivingPage> pageList = new ArrayList<IostReceivingPage>();
      for (IostReceiving main : iostReceivingList) {
          IostReceivingPage vo = new IostReceivingPage();
          BeanUtils.copyProperties(main, vo);
          List<IostReceivinglist> iostReceivinglistList = iostReceivinglistService.selectByMainId(main.getId());
          vo.setIostReceivinglistList(iostReceivinglistList);
          pageList.add(vo);
      }

      // Step.4 AutoPoi 导出Excel
      ModelAndView mv = new ModelAndView(new JeecgEntityExcelView());
      mv.addObject(NormalExcelConstants.FILE_NAME, "入仓单列表");
      mv.addObject(NormalExcelConstants.CLASS, IostReceivingPage.class);
      mv.addObject(NormalExcelConstants.PARAMS, new ExportParams("入仓单数据", "导出人:"+sysUser.getRealname(), "入仓单"));
      mv.addObject(NormalExcelConstants.DATA_LIST, pageList);
      return mv;
    }

    /**
    * 通过excel导入数据
    *
    * @param request
    * @param response
    * @return
    */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
      MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
      Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
      for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
          MultipartFile file = entity.getValue();// 获取上传文件对象
          ImportParams params = new ImportParams();
          params.setTitleRows(2);
          params.setHeadRows(1);
          params.setNeedSave(true);
          try {
              List<IostReceivingPage> list = ExcelImportUtil.importExcel(file.getInputStream(), IostReceivingPage.class, params);
              for (IostReceivingPage page : list) {
                  IostReceiving po = new IostReceiving();
                  BeanUtils.copyProperties(page, po);
                  iostReceivingService.saveMain(po, page.getIostReceivinglistList());
              }
              return Result.OK("文件导入成功！数据行数:" + list.size());
          } catch (Exception e) {
              log.error(e.getMessage(),e);
              return Result.error("文件导入失败:"+e.getMessage());
          } finally {
              try {
                  file.getInputStream().close();
              } catch (IOException e) {
                  e.printStackTrace();
              }
          }
      }
      return Result.OK("文件导入失败！");
    }

}
