package org.jeecg.modules.iost.basedata.controller;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jeecg.modules.iost.basedata.entity.*;
import org.jeecg.modules.iost.basedata.service.*;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.jeecg.common.system.vo.LoginUser;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.iost.basedata.vo.IostDeliveryNotePage;
import org.jeecg.modules.iost.basedata.vo.IostReceivingNotePage;
import org.jeecg.modules.iost.basedata.vo.IostSummarySheetPage;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import lombok.extern.slf4j.Slf4j;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;

/**
 * @Description: 汇总单
 * @Author: jeecg-boot
 * @Date:   2020-12-22
 * @Version: V1.0
 */
@Api(tags="汇总单")
@RestController
@RequestMapping("/basedata/iostSummarySheet")
@Slf4j
public class IostSummarySheetController {
	@Autowired
	private IIostSummarySheetService iostSummarySheetService;
	@Autowired
	private IIostSummarySheetListService iostSummarySheetListService;

	@Autowired
	private IIostDeliveryRecordService iostDeliveryRecordService;
	@Autowired
	private IIostDeliveryRecordListService iostDeliveryRecordListService;
	@Autowired
	private IIostReceivingNoteService iostReceivingNoteService;
	@Autowired
	private IIostDeliveryNoteService iostDeliveryNoteService;
	@Autowired
	private IIostCustomerService iostCustomerService;
	@Autowired
	private IIostCustomerlistService iostCustomerlistService;
	@Autowired
	private IIostDeliveryRecordPicService iostDeliveryRecordPicService;
	
	/**
	 * 分页列表查询
	 *
	 * @param iostSummarySheet
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	@AutoLog(value = "汇总单-分页列表查询")
	@ApiOperation(value="汇总单-分页列表查询", notes="汇总单-分页列表查询")
	@GetMapping(value = "/list")
	public Result<?> queryPageList(IostSummarySheet iostSummarySheet,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<IostSummarySheet> queryWrapper = QueryGenerator.initQueryWrapper(iostSummarySheet, req.getParameterMap());
		Page<IostSummarySheet> page = new Page<IostSummarySheet>(pageNo, pageSize);
		IPage<IostSummarySheet> pageList = iostSummarySheetService.page(page, queryWrapper);
		return Result.OK(pageList);
	}
	
	/**
	 *   添加
	 *
	 * @param iostSummarySheetPage
	 * @return
	 */
	@AutoLog(value = "汇总单-添加")
	@ApiOperation(value="汇总单-添加", notes="汇总单-添加")
	@PostMapping(value = "/add")
	public Result<?> add(@RequestBody IostSummarySheetPage iostSummarySheetPage) {
		IostSummarySheet iostSummarySheet = new IostSummarySheet();
		BeanUtils.copyProperties(iostSummarySheetPage, iostSummarySheet);
		iostSummarySheetService.saveMain(iostSummarySheet, iostSummarySheetPage.getIostSummarySheetListList());
		return Result.OK("添加成功！");
	}
	
	/***
	 * 汇总单-通过出库单id来创建汇总单
	 * @param id
	 * @return
	 */
	@AutoLog(value = "汇总单-通过出库单id来创建汇总单")
	@ApiOperation(value="汇总单-通过出库单id来创建汇总单", notes="汇总单-通过出库单id来创建汇总单")
	@GetMapping(value = "/addFromDeliveryManagement")
	public Result<?> addFromDeliveryManagement(@RequestParam(name="id",required=true) String id)
	{
        LambdaQueryWrapper<IostSummarySheet> query = new LambdaQueryWrapper<IostSummarySheet>().eq(IostSummarySheet::getDeliveryRecordId, id);
		int count = iostSummarySheetService.count(query);
		if(count > 0)
		{
			return Result.error("已经生成汇总单，不能再生成汇总单！");
		}
		
		IostDeliveryRecord iostDeliveryRecordEntity = iostDeliveryRecordService.getById(id);

		IostSummarySheet iostSummarySheet = new IostSummarySheet();
		iostSummarySheet.setBulkNo(iostDeliveryRecordEntity.getBulkNo());
		iostSummarySheet.setContainerNo(iostDeliveryRecordEntity.getContainerNo());
		iostSummarySheet.setLoadingDate(iostDeliveryRecordEntity.getLoadingDate());
		iostSummarySheet.setWarehouseName(iostDeliveryRecordEntity.getWarehouseName());
		iostSummarySheet.setDeliveryRecordId(id);
		
		List<IostSummarySheetList> iostSummarySheetLists = iostDeliveryRecordListService.getSummaryLists(id);
		iostSummarySheetService.saveMain(iostSummarySheet, iostSummarySheetLists);
		return Result.OK("生成汇总单成功！");
	}
	

	/***
	 * 收费单-通过出库单id来创建收费单
	 * @param id
	 * @return
	 */
	@AutoLog(value = "收费单-通过出库单id来创建收费单")
	@ApiOperation(value="收费单-通过出库单id来创建收费单", notes="汇总单-通过出库单id来创建收费单")
	@GetMapping(value = "/addToReceivingNote")
	public Result<?> addToReceivingNote(@RequestParam(name="id",required=true) String id, @RequestParam(name="sumId",required=true) String sumId)
	{
        LambdaQueryWrapper<IostReceivingNote> query = new LambdaQueryWrapper<IostReceivingNote>().eq(IostReceivingNote::getDeliveryRecordId, id);
		int count = iostReceivingNoteService.count(query);
		if(count > 0)
		{
			return Result.error("已经生成收费单，不能再生成收费单！");
		}
		
		List<IostSummarySheetList> iostSummarySheetLists = iostSummarySheetListService.selectByMainId(sumId);
		HashMap<String, HashMap<String, Integer>> iostSummarySheetListIndexMap = new HashMap<String, HashMap<String, Integer>>();

		for(int i = 0; i< iostSummarySheetLists.size(); i ++)
		{
			IostSummarySheetList iostSummarySheetList = iostSummarySheetLists.get(i);
			if(!iostSummarySheetListIndexMap.containsKey(iostSummarySheetList.getCustomerName()))
			{
				HashMap<String, Integer> iostSummarySheetListMap = new HashMap<String, Integer>();
				iostSummarySheetListIndexMap.put(iostSummarySheetList.getCustomerName(), iostSummarySheetListMap);
			}
			HashMap<String, Integer> iostSummarySheetListMap = iostSummarySheetListIndexMap.get(iostSummarySheetList.getCustomerName());
			if(!iostSummarySheetListMap.containsKey(iostSummarySheetList.getReceivingNo()))
			{
				iostSummarySheetListMap.put(iostSummarySheetList.getReceivingNo(), i);
			}
		}
		
		List<IostReceivingNotePage> iostReceivingNotes = new ArrayList<IostReceivingNotePage>();
		HashMap<String, HashMap<String, IostReceivingNotePage>> iostReceivingNoteMap = new HashMap<String, HashMap<String, IostReceivingNotePage>>();

		List<IostCustomer> iostCustomers = iostCustomerService.list();
		HashMap<String, IostCustomer> ceNameMap = new HashMap<String, IostCustomer>();
		for(IostCustomer iostCustomer:iostCustomers)
		{
			if(!ceNameMap.containsKey(iostCustomer.getNameChs()))
			{
				ceNameMap.put(iostCustomer.getNameChs(), iostCustomer);
			}
		}
		
		List<IostCustomerlist> iostCustomerlists = iostCustomerlistService.list();
		HashMap<String, IostCustomerlist> listMap = new HashMap<String, IostCustomerlist>();
		for(IostCustomerlist iostCustomerlist:iostCustomerlists)
		{
			if(!listMap.containsKey(iostCustomerlist.getCustomerId()) && "Y".equals(iostCustomerlist.getAddressDefault()))
			{
				listMap.put(iostCustomerlist.getCustomerId(), iostCustomerlist);
			}
		}
		
		IostDeliveryRecord iostDeliveryRecord = iostDeliveryRecordService.getById(id);
		List<IostDeliveryRecordList> iostDeliveryRecordLists = iostDeliveryRecordListService.selectByMainId(id);
		for(IostDeliveryRecordList iostDeliveryRecordList:iostDeliveryRecordLists)
		{
			String customerName = iostDeliveryRecordList.getCustomerName();
			IostCustomer iostCustomer = null;
			IostCustomerlist iostCustomerlist = null;
			if(ceNameMap.containsKey(customerName))
			{
				iostCustomer = ceNameMap.get(customerName);
				if(listMap.containsKey(iostCustomer.getId()))
				{
					iostCustomerlist = listMap.get(iostCustomer.getId());
				}
			}
			if(!iostReceivingNoteMap.containsKey(customerName))
			{
				HashMap<String, IostReceivingNotePage> iostReceivingMap = new HashMap<String, IostReceivingNotePage>();
				iostReceivingNoteMap.putIfAbsent(customerName, iostReceivingMap);
			}
			String receivingNo = iostDeliveryRecordList.getReceivingNo();
			HashMap<String, IostReceivingNotePage> iostReceivingMap = iostReceivingNoteMap.get(customerName);
			if(!iostReceivingMap.containsKey(receivingNo))
			{
				IostReceivingNotePage iostReceivingNotePage = new IostReceivingNotePage();
				iostReceivingNotePage.setCustomerName(customerName);
				iostReceivingNotePage.setReceivingNo(receivingNo);
				iostReceivingNotePage.setDate(new Date());

				if(iostSummarySheetListIndexMap.containsKey(customerName))
				{
					HashMap<String, Integer> iostSummarySheetListMap = iostSummarySheetListIndexMap.get(customerName);
					if(iostSummarySheetListMap.containsKey(receivingNo))
					{
						int curIndex = iostSummarySheetListMap.get(receivingNo);
						iostReceivingNotePage.setInvoiceNumber(iostDeliveryRecord.getBulkNo() + (curIndex+ 1));
					}
				}
				if(iostCustomer != null)
				{
					iostReceivingNotePage.setTelephone(iostCustomer.getTelephone());
				}
				
				if(iostCustomerlist != null)
				{
					iostReceivingNotePage.setDeliveryAddress(iostCustomerlist.getAddress());
				}
				
				iostReceivingNotePage.setIostReceivingNoteListList(new ArrayList<IostReceivingNoteList>());
				iostReceivingMap.put(receivingNo, iostReceivingNotePage);
				iostReceivingNotes.add(iostReceivingNotePage);
			}
			
			IostReceivingNotePage iostReceivingNotePage = iostReceivingMap.get(receivingNo);
			IostReceivingNoteList iostReceivingNoteList = new IostReceivingNoteList();
			iostReceivingNoteList.setMoney(iostDeliveryRecordList.getMoney());
			iostReceivingNoteList.setNameChs(iostDeliveryRecordList.getNameChs());
			iostReceivingNoteList.setNameEng(iostDeliveryRecordList.getNameEng());
			iostReceivingNoteList.setPackages(iostDeliveryRecordList.getCasesActual());
			iostReceivingNoteList.setPrice(iostDeliveryRecordList.getPrice());
			iostReceivingNoteList.setVolume(iostDeliveryRecordList.getVolumeTotal());
			iostReceivingNoteList.setWeight(iostDeliveryRecordList.getWeightTotal());
			iostReceivingNotePage.getIostReceivingNoteListList().add(iostReceivingNoteList);
		}
		
		for(IostReceivingNotePage iostReceivingNotePage:iostReceivingNotes)
		{
			IostReceivingNote iostReceivingNote = new IostReceivingNote();
			BeanUtils.copyProperties(iostReceivingNotePage, iostReceivingNote);
			iostReceivingNote.setDeliveryRecordId(id);
			iostReceivingNoteService.saveMain(iostReceivingNote, iostReceivingNotePage.getIostReceivingNoteListList());
		}
		return Result.OK("生成收费单成功！");
	}
	

	/***
	 * DeliveryNote-通过出库单id来创建收费单
	 * @param id
	 * @return
	 */
	@AutoLog(value = "送货单-通过出库单id来创建送货单")
	@ApiOperation(value="送货单-通过出库单id来创建送货单", notes="DeliveryNote-通过出库单id来创建送货单")
	@GetMapping(value = "/addToDeliveryNote")
	public Result<?> addToDeliveryNote(@RequestParam(name="id",required=true) String id, @RequestParam(name="sumId",required=true) String sumId)
	{
        LambdaQueryWrapper<IostDeliveryNote> query = new LambdaQueryWrapper<IostDeliveryNote>().eq(IostDeliveryNote::getDeliveryRecordId, id);
		int count = iostDeliveryNoteService.count(query);
		if(count > 0)
		{
			return Result.error("已经生成送货单，不能再生成送货单！");
		}
		
		List<IostCustomer> iostCustomers = iostCustomerService.list();
		HashMap<String, IostCustomer> ceNameMap = new HashMap<String, IostCustomer>();
		for(IostCustomer iostCustomer:iostCustomers)
		{
			if(!ceNameMap.containsKey(iostCustomer.getNameChs()))
			{
				ceNameMap.put(iostCustomer.getNameChs(), iostCustomer);
			}
		}

		IostDeliveryRecord iostDeliveryRecord = iostDeliveryRecordService.getById(id);
		List<IostCustomerlist> iostCustomerlists = iostCustomerlistService.list();
		HashMap<String, IostCustomerlist> listMap = new HashMap<String, IostCustomerlist>();
		for(IostCustomerlist iostCustomerlist:iostCustomerlists)
		{
			if(!listMap.containsKey(iostCustomerlist.getCustomerId()) && "Y".equals(iostCustomerlist.getAddressDefault()))
			{
				listMap.put(iostCustomerlist.getCustomerId(), iostCustomerlist);
			}
		}
		
		List<IostSummarySheetList> iostSummarySheetLists = iostSummarySheetListService.selectByMainId(sumId);
		HashMap<String, HashMap<String, Integer>> iostSummarySheetListIndexMap = new HashMap<String, HashMap<String, Integer>>();

		for(int i = 0; i< iostSummarySheetLists.size(); i ++)
		{
			IostSummarySheetList iostSummarySheetList = iostSummarySheetLists.get(i);
			if(!iostSummarySheetListIndexMap.containsKey(iostSummarySheetList.getCustomerName()))
			{
				HashMap<String, Integer> iostSummarySheetListMap = new HashMap<String, Integer>();
				iostSummarySheetListIndexMap.put(iostSummarySheetList.getCustomerName(), iostSummarySheetListMap);
			}
			HashMap<String, Integer> iostSummarySheetListMap = iostSummarySheetListIndexMap.get(iostSummarySheetList.getCustomerName());
			if(!iostSummarySheetListMap.containsKey(iostSummarySheetList.getReceivingNo()))
			{
				iostSummarySheetListMap.put(iostSummarySheetList.getReceivingNo(), i);
			}
		}
		
		List<IostDeliveryNotePage> iostDeliveryNotePages = new ArrayList<IostDeliveryNotePage>();
		HashMap<String, HashMap<String, IostDeliveryNotePage>> iostReceivingNoteMap = new HashMap<String, HashMap<String, IostDeliveryNotePage>>();
		
		List<IostDeliveryRecordList> iostDeliveryRecordLists = iostDeliveryRecordListService.selectByMainId(id);
		for(IostDeliveryRecordList iostDeliveryRecordList:iostDeliveryRecordLists)
		{
			String customerName = iostDeliveryRecordList.getCustomerName();
			IostCustomer iostCustomer = null;
			IostCustomerlist iostCustomerlist = null;
			String receivingNo = iostDeliveryRecordList.getReceivingNo();
			
			int curIndex = 0;

			if(iostSummarySheetListIndexMap.containsKey(customerName))
			{
				HashMap<String, Integer> iostSummarySheetListMap = iostSummarySheetListIndexMap.get(customerName);
				if(iostSummarySheetListMap.containsKey(receivingNo))
				{
					curIndex = iostSummarySheetListMap.get(receivingNo);
				}
			}
			
			if(ceNameMap.containsKey(customerName))
			{
				iostCustomer = ceNameMap.get(customerName);
				customerName = iostCustomer.getNameEng();
				if(listMap.containsKey(iostCustomer.getId()))
				{
					iostCustomerlist = listMap.get(iostCustomer.getId());
				}
			}
			if(!iostReceivingNoteMap.containsKey(customerName))
			{
				HashMap<String, IostDeliveryNotePage> iostReceivingMap = new HashMap<String, IostDeliveryNotePage>();
				iostReceivingNoteMap.putIfAbsent(customerName, iostReceivingMap);
			}
			HashMap<String, IostDeliveryNotePage> iostReceivingMap = iostReceivingNoteMap.get(customerName);
			if(!iostReceivingMap.containsKey(receivingNo))
			{
				IostDeliveryNotePage iostReceivingNotePage = new IostDeliveryNotePage();
				iostReceivingNotePage.setContactName(customerName);
				iostReceivingNotePage.setDate(new Date());
				iostReceivingNotePage.setReference(iostDeliveryRecord.getBulkNo() + (curIndex + 1));
				if(iostCustomer != null)
				{
					iostReceivingNotePage.setCompany(iostCustomer.getCompany());
					iostReceivingNotePage.setPhoneNo(iostCustomer.getTelephone());
				}
				if(iostCustomerlist != null)
				{
					iostReceivingNotePage.setAddress(iostCustomerlist.getAddress());
				}
				//iostReceivingNotePage.setReceivingNo(receivingNo);
				iostReceivingNotePage.setIostDeliveryNoteListList(new ArrayList<IostDeliveryNoteList>());
				iostReceivingMap.put(receivingNo, iostReceivingNotePage);
				iostDeliveryNotePages.add(iostReceivingNotePage);
			}
			
			IostDeliveryNotePage iostReceivingNotePage = iostReceivingMap.get(receivingNo);
			IostDeliveryNoteList iostReceivingNoteList = new IostDeliveryNoteList();
			iostReceivingNoteList.setCbm(iostDeliveryRecordList.getVolumeTotal());
			iostReceivingNoteList.setCtns(iostDeliveryRecordList.getCasesActual());
			iostReceivingNoteList.setHeight(iostDeliveryRecordList.getHeight());
			iostReceivingNoteList.setWidth(iostDeliveryRecordList.getWidth());
			iostReceivingNoteList.setLength(iostDeliveryRecordList.getLength());
			iostReceivingNoteList.setWeight(iostDeliveryRecordList.getWeightTotal());
			iostReceivingNoteList.setMark(receivingNo);
			iostReceivingNoteList.setDescription(iostDeliveryRecordList.getNameEng());
			iostReceivingNotePage.getIostDeliveryNoteListList().add(iostReceivingNoteList);
		}
		
		for(IostDeliveryNotePage iostDeliveryNotePage:iostDeliveryNotePages)
		{
			IostDeliveryNote curIostDeliveryNote = new IostDeliveryNote();
			BeanUtils.copyProperties(iostDeliveryNotePage, curIostDeliveryNote);
			curIostDeliveryNote.setDeliveryRecordId(id);
			iostDeliveryNoteService.saveMain(curIostDeliveryNote, iostDeliveryNotePage.getIostDeliveryNoteListList());
		}
		return Result.OK("生成送货单成功！");
	}
	
	
	/**
	 *  编辑
	 *
	 * @param iostSummarySheetPage
	 * @return
	 */
	@AutoLog(value = "汇总单-编辑")
	@ApiOperation(value="汇总单-编辑", notes="汇总单-编辑")
	@PutMapping(value = "/edit")
	public Result<?> edit(@RequestBody IostSummarySheetPage iostSummarySheetPage) {
		IostSummarySheet iostSummarySheet = new IostSummarySheet();
		BeanUtils.copyProperties(iostSummarySheetPage, iostSummarySheet);
		IostSummarySheet iostSummarySheetEntity = iostSummarySheetService.getById(iostSummarySheet.getId());
		if(iostSummarySheetEntity==null) {
			return Result.error("未找到对应数据");
		}
		iostSummarySheetService.updateMain(iostSummarySheet, iostSummarySheetPage.getIostSummarySheetListList());
		return Result.OK("编辑成功!");
	}
	
	/**
	 *   通过id删除
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "汇总单-通过id删除")
	@ApiOperation(value="汇总单-通过id删除", notes="汇总单-通过id删除")
	@DeleteMapping(value = "/delete")
	@RequiresPermissions("summarySheet:delete")
	public Result<?> delete(@RequestParam(name="id",required=true) String id) {
		iostSummarySheetService.delMain(id);
		return Result.OK("删除成功!");
	}
	
	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "汇总单-批量删除")
	@ApiOperation(value="汇总单-批量删除", notes="汇总单-批量删除")
	@DeleteMapping(value = "/deleteBatch")
	@RequiresPermissions("summarySheet:delete")
	public Result<?> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.iostSummarySheetService.delBatchMain(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功！");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "汇总单-通过id查询")
	@ApiOperation(value="汇总单-通过id查询", notes="汇总单-通过id查询")
	@GetMapping(value = "/queryById")
	public Result<?> queryById(@RequestParam(name="id",required=true) String id) {
		IostSummarySheet iostSummarySheet = iostSummarySheetService.getById(id);
		if(iostSummarySheet==null) {
			return Result.error("未找到对应数据");
		}
		return Result.OK(iostSummarySheet);

	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "汇总明细通过主表ID查询")
	@ApiOperation(value="汇总明细主表ID查询", notes="汇总明细-通主表ID查询")
	@GetMapping(value = "/queryIostSummarySheetListByMainId")
	public Result<?> queryIostSummarySheetListListByMainId(@RequestParam(name="id",required=true) String id) {
		List<IostSummarySheetList> iostSummarySheetListList = iostSummarySheetListService.selectByMainId(id);
		return Result.OK(iostSummarySheetListList);
	}

	 /**
	  * 打印收费单
	  *
	  * @param id
	  * @return
	  */
	 @AutoLog(value = "打印收费单")
	 @ApiOperation(value="打印收费单", notes="汇总明细-打印收费单")
	 @GetMapping(value = "/queryIostSummarySheetListByMainIdiostListByMainId")
	 public Result<?> queryIostReceivingNoteListListMainId(@RequestParam(name="id",required=true) String id) {
		 List<IostSummarySheetList> iostReceivingNoteListList = iostSummarySheetListService.selectByMainId(id);
		 iostReceivingNoteListList.add(addSumRow(iostReceivingNoteListList));
		 return Result.OK(iostReceivingNoteListList);
	 }

	 /**
	  *  编辑
	  *
	  * @param iostDeliveryRecordPic
	  * @return
	  */
	 @AutoLog(value = "上传汇总单-编辑")
	 @ApiOperation(value="上传汇总单-编辑", notes="上传汇总单-编辑")
	 @PutMapping(value = "/updateSummarySheetList")
	 public Result<?> edit(@RequestBody IostDeliveryRecordPic iostDeliveryRecordPic) {
			IostDeliveryRecordPic curPic = iostDeliveryRecordPicService.getById(iostDeliveryRecordPic.getId());
	 		if(curPic!=null){
				iostDeliveryRecordPicService.updateById(iostDeliveryRecordPic);
			}else{
				iostDeliveryRecordPicService.save(iostDeliveryRecordPic);
			}
	 		IostSummarySheetList sheetList = iostSummarySheetListService.getById(iostDeliveryRecordPic.getId());
	 		sheetList.setDeliverStatus("2");
		 iostSummarySheetListService.updateById(sheetList);
		 return Result.OK("编辑成功!");
	 }

	 /***
	  * 增加统计行
	  * @param iostSummarySheetLists
	  */
	 private IostSummarySheetList addSumRow(List<IostSummarySheetList> iostSummarySheetLists)
	 {
		 double totlevolume = 0;//体积总
		 double totleWeightTotal = 0;//重量总
		 int totlePackagesTotal = 0;//箱数总
		 double totleMoney = 0;//金额总
		 for(IostSummarySheetList iostSummarySheetList: iostSummarySheetLists)
		 {
			 BigDecimal A1;
			 BigDecimal A2;
			 if(iostSummarySheetList.getVolume()!=null){
				 A1 = new BigDecimal(Double.toString(totlevolume));
				 A2 = new BigDecimal(Double.toString(iostSummarySheetList.getVolume()));
				 totlevolume = A1.add(A2).doubleValue();
			 }
			 if(iostSummarySheetList.getWeight()!=null){
				 A1 = new BigDecimal(Double.toString(totleWeightTotal));
				 A2 = new BigDecimal(Double.toString(iostSummarySheetList.getWeight()));
				 totleWeightTotal = A1.add(A2).doubleValue();
			 }
			 if(iostSummarySheetList.getPackages()!=null){
				 totlePackagesTotal = totlePackagesTotal + iostSummarySheetList.getPackages();
			 }
			 if(iostSummarySheetList.getMoney()!=null){
				 A1 = new BigDecimal(Double.toString(totleMoney));
				 A2 = new BigDecimal(Double.toString(iostSummarySheetList.getMoney()));
				 totleMoney = A1.add(A2).doubleValue();
			 }
		 }

		 IostSummarySheetList iostSummarySheetList = new IostSummarySheetList();
		 iostSummarySheetList.setCustomerName("总和");
		 //iostSummarySheetList.setVolume((Double.valueOf(String.format("%.2f", totlevolume))));
		 iostSummarySheetList.setVolume(totlevolume);
		 iostSummarySheetList.setWeight(totleWeightTotal);
		 iostSummarySheetList.setPackages(totlePackagesTotal);
		 iostSummarySheetList.setMoney(totleMoney);
		 return iostSummarySheetList;
	 }

    /**
    * 导出excel
    *
    * @param request
    * @param iostSummarySheet
    */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, IostSummarySheet iostSummarySheet) {
      // Step.1 组装查询条件查询数据
      QueryWrapper<IostSummarySheet> queryWrapper = QueryGenerator.initQueryWrapper(iostSummarySheet, request.getParameterMap());
      LoginUser sysUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();

      //Step.2 获取导出数据
      List<IostSummarySheet> queryList = iostSummarySheetService.list(queryWrapper);
      // 过滤选中数据
      String selections = request.getParameter("selections");
      List<IostSummarySheet> iostSummarySheetList = new ArrayList<IostSummarySheet>();
      if(oConvertUtils.isEmpty(selections)) {
          iostSummarySheetList = queryList;
      }else {
          List<String> selectionList = Arrays.asList(selections.split(","));
          iostSummarySheetList = queryList.stream().filter(item -> selectionList.contains(item.getId())).collect(Collectors.toList());
      }

      // Step.3 组装pageList
		List<IostSummarySheetList> iostSummarySheetPagesList = new ArrayList<IostSummarySheetList>();//记录需要总数的数据
      List<IostSummarySheetPage> pageList = new ArrayList<IostSummarySheetPage>();
      for (IostSummarySheet main : iostSummarySheetList) {
		  IostSummarySheetPage vo = new IostSummarySheetPage();
		  BeanUtils.copyProperties(main, vo);
		  List<IostSummarySheetList> iostSummarySheetListList = iostSummarySheetListService.selectByMainId(main.getId());
		  vo.setIostSummarySheetListList(iostSummarySheetListList);
		  pageList.add(vo);
		  iostSummarySheetPagesList.add(addSumRow(iostSummarySheetListList));
	  }
      //把总数放入pageList
      IostSummarySheetPage list = new IostSummarySheetPage();
      List<IostSummarySheetList> listzongshu = new ArrayList<>();
      listzongshu.add(addSumRow(iostSummarySheetPagesList));
      list.setIostSummarySheetListList(listzongshu);
      pageList.add(list);
      // Step.4 AutoPoi 导出Excel
      ModelAndView mv = new ModelAndView(new JeecgEntityExcelView());
      mv.addObject(NormalExcelConstants.FILE_NAME, "汇总单列表");
      mv.addObject(NormalExcelConstants.CLASS, IostSummarySheetPage.class);
      mv.addObject(NormalExcelConstants.PARAMS, new ExportParams("汇总单数据", "导出人:"+sysUser.getRealname(), "汇总单"));
      mv.addObject(NormalExcelConstants.DATA_LIST, pageList);
      return mv;
    }

    /**
    * 通过excel导入数据
    *
    * @param request
    * @param response
    * @return
    */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
      MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
      Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
      for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
          MultipartFile file = entity.getValue();// 获取上传文件对象
          ImportParams params = new ImportParams();
          params.setTitleRows(2);
          params.setHeadRows(1);
          params.setNeedSave(true);
          try {
              List<IostSummarySheetPage> list = ExcelImportUtil.importExcel(file.getInputStream(), IostSummarySheetPage.class, params);
              for (IostSummarySheetPage page : list) {
                  IostSummarySheet po = new IostSummarySheet();
                  BeanUtils.copyProperties(page, po);
                  iostSummarySheetService.saveMain(po, page.getIostSummarySheetListList());
              }
              return Result.OK("文件导入成功！数据行数:" + list.size());
          } catch (Exception e) {
              log.error(e.getMessage(),e);
              return Result.error("文件导入失败:"+e.getMessage());
          } finally {
              try {
                  file.getInputStream().close();
              } catch (IOException e) {
                  e.printStackTrace();
              }
          }
      }
      return Result.OK("文件导入失败！");
    }

}
