package org.jeecg.modules.iost.basedata.entity;

import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import java.util.Date;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @Description: 保险明细
 * @Author: jeecg-boot
 * @Date:   2020-11-20
 * @Version: V1.0
 */
@ApiModel(value="iost_insurance_policy对象", description="保险单")
@Data
@TableName("iost_insurance_policy_list")
public class IostInsurancePolicyList implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
	@ApiModelProperty(value = "主键")
	private java.lang.String id;
	/**创建人*/
	@ApiModelProperty(value = "创建人")
	private java.lang.String createBy;
	/**创建日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
	@ApiModelProperty(value = "创建日期")
	private java.util.Date createTime;
	/**更新人*/
	@ApiModelProperty(value = "更新人")
	private java.lang.String updateBy;
	/**更新日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
	@ApiModelProperty(value = "更新日期")
	private java.util.Date updateTime;
	/**所属部门*/
	@ApiModelProperty(value = "所属部门")
	private java.lang.String sysOrgCode;
	/**商品名称*/
	@Excel(name = "商品名称", width = 15)
	@ApiModelProperty(value = "商品名称")
	private java.lang.String name;
	/**体积*/
	@Excel(name = "体积", width = 15)
	@ApiModelProperty(value = "体积")
	private java.lang.Integer volume;
	/**重量*/
	@Excel(name = "重量", width = 15)
	@ApiModelProperty(value = "重量")
	private java.lang.Double weight;
	/**箱数*/
	@Excel(name = "箱数", width = 15)
	@ApiModelProperty(value = "箱数")
	private java.lang.Integer packages;
	/**价格*/
	@Excel(name = "价格", width = 15)
	@ApiModelProperty(value = "价格")
	private java.lang.Double price;
	/** 金额*/
	@Excel(name = " 金额", width = 15)
	@ApiModelProperty(value = " 金额")
	private java.lang.Double money;
	/**入仓号*/
	@Excel(name = "入仓号", width = 15)
	@ApiModelProperty(value = "入仓号")
	private java.lang.String receivingNo;
	/**保险id*/
	@ApiModelProperty(value = "保险id")
	private java.lang.String insurancePolicyId;
}
