package org.jeecg.modules.iost.basedata.entity;

import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import java.util.Date;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @Description: 库存记录表
 * @Author: jeecg-boot
 * @Date:   2020-11-10
 * @Version: V1.0
 */
@ApiModel(value="iost_inventory_record对象", description="库存记录")
@Data
@TableName("iost_inventory_record_list")
public class IostInventoryRecordList implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
	@ApiModelProperty(value = "主键")
	private java.lang.String id;
	/**创建人*/
	@ApiModelProperty(value = "创建人")
	private java.lang.String createBy;
	/**创建日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
	@ApiModelProperty(value = "创建日期")
	private java.util.Date createTime;
	/**更新人*/
	@ApiModelProperty(value = "更新人")
	private java.lang.String updateBy;
	/**更新日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
	@ApiModelProperty(value = "更新日期")
	private java.util.Date updateTime;
	/**所属部门*/
	@ApiModelProperty(value = "所属部门")
	private java.lang.String sysOrgCode;
	/**商品中文名称*/
	@Excel(name = "商品中文名称", width = 15)
	@ApiModelProperty(value = "商品中文名称")
	private java.lang.String nameChs;
	/**商品英文名称*/
	@Excel(name = "商品英文名称", width = 15)
	@ApiModelProperty(value = "商品英文名称")
	private java.lang.String nameEng;
	/**图片*/
	@Excel(name = "图片", width = 15)
	@ApiModelProperty(value = "图片")
	private java.lang.String picture;
	/**单位*/
	@Excel(name = "单位", width = 15)
	@ApiModelProperty(value = "单位")
	private java.lang.String unit;
	/**件数*/
	@Excel(name = "件数", width = 15)
	@ApiModelProperty(value = "件数")
	private java.lang.String cases;
	/**装箱数*/
	@Excel(name = "装箱数", width = 15)
	@ApiModelProperty(value = "装箱数")
	private java.lang.String packages;
	/**总装箱数*/
	@Excel(name = "总装箱数", width = 15)
	@ApiModelProperty(value = "总装箱数")
	private java.lang.String packagesTotal;
	/**长*/
	@Excel(name = "长", width = 15)
	@ApiModelProperty(value = "长")
	private java.lang.String length;
	/**宽*/
	@Excel(name = "宽", width = 15)
	@ApiModelProperty(value = "宽")
	private java.lang.String width;
	/**高*/
	@Excel(name = "高", width = 15)
	@ApiModelProperty(value = "高")
	private java.lang.String height;
	/**体积*/
	@Excel(name = "体积", width = 15)
	@ApiModelProperty(value = "体积")
	private java.lang.String volume;
	/**总体积*/
	@Excel(name = "总体积", width = 15)
	@ApiModelProperty(value = "总体积")
	private java.lang.String volumeTotal;
	/**箱重*/
	@Excel(name = "箱重", width = 15)
	@ApiModelProperty(value = "箱重")
	private java.lang.String weight;
	/**总重量*/
	@Excel(name = "总重量", width = 15)
	@ApiModelProperty(value = "总重量")
	private java.lang.String weightTotal;
	/**材质*/
	@Excel(name = "材质", width = 15)
	@ApiModelProperty(value = "材质")
	private java.lang.String material;
	/**入仓号*/
	@Excel(name = "入仓号", width = 15)
	@ApiModelProperty(value = "入仓号")
	private java.lang.String receivingNo;
	/**客户中文姓名*/
	@Excel(name = "客户中文姓名", width = 15)
	@ApiModelProperty(value = "客户中文姓名")
	private java.lang.String customerName;
	/**记录id*/
	@ApiModelProperty(value = "记录id")
	private java.lang.String recordId;
}
