package org.jeecg.modules.iost.basedata.entity;

import java.io.Serializable;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @Description: 汇总单
 * @Author: jeecg-boot
 * @Date:   2020-12-23
 * @Version: V1.0
 */
@ApiModel(value="iost_summary_sheet对象", description="汇总单")
@Data
@TableName("iost_summary_sheet")
public class IostSummarySheet implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private java.lang.String id;
	/**创建人*/
    @ApiModelProperty(value = "创建人")
    private java.lang.String createBy;
	/**创建日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private java.util.Date createTime;
	/**更新人*/
    @ApiModelProperty(value = "更新人")
    private java.lang.String updateBy;
	/**更新日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private java.util.Date updateTime;
	/**所属部门*/
    @ApiModelProperty(value = "所属部门")
    private java.lang.String sysOrgCode;
	/**散货柜编号*/
	@Excel(name = "散货柜编号", width = 15)
    @ApiModelProperty(value = "散货柜编号")
    private java.lang.String bulkNo;
	/**仓库名称*/
	@Excel(name = "仓库名称", width = 15, dictTable = "iost_storage", dicText = "name", dicCode = "id")
    @Dict(dictTable = "iost_storage", dicText = "name", dicCode = "id")
    @ApiModelProperty(value = "仓库名称")
    private java.lang.String warehouseName;
	/**货柜号*/
	@Excel(name = "货柜号", width = 15)
    @ApiModelProperty(value = "货柜号")
    private java.lang.String containerNo;
	/**装柜日期*/
	@Excel(name = "装柜日期", width = 15, format = "yyyy-MM-dd")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    @ApiModelProperty(value = "装柜日期")
    private java.util.Date loadingDate;
	/**出库单Id*/
	@Excel(name = "出库单Id", width = 15)
    @ApiModelProperty(value = "出库单Id")
    private java.lang.String deliveryRecordId;
}
