package org.jeecg.modules.iost.basedata.service.impl;

import org.jeecg.modules.iost.basedata.entity.IostDeliverstatus;
import org.jeecg.modules.iost.basedata.entity.IostDeliverstatusList;
import org.jeecg.modules.iost.basedata.mapper.IostDeliverstatusListMapper;
import org.jeecg.modules.iost.basedata.mapper.IostDeliverstatusMapper;
import org.jeecg.modules.iost.basedata.service.IIostDeliverstatusService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import java.io.Serializable;
import java.util.List;
import java.util.Collection;

/**
 * @Description: 更新物流状态
 * @Author: jeecg-boot
 * @Date:   2020-11-16
 * @Version: V1.0
 */
@Service
public class IostDeliverstatusServiceImpl extends ServiceImpl<IostDeliverstatusMapper, IostDeliverstatus> implements IIostDeliverstatusService {

	@Autowired
	private IostDeliverstatusMapper iostDeliverstatusMapper;
	@Autowired
	private IostDeliverstatusListMapper iostDeliverstatusListMapper;
	
	@Override
	@Transactional
	public void saveMain(IostDeliverstatus iostDeliverstatus, List<IostDeliverstatusList> iostDeliverstatusListList) {
		iostDeliverstatusMapper.insert(iostDeliverstatus);
		if(iostDeliverstatusListList!=null && iostDeliverstatusListList.size()>0) {
			for(IostDeliverstatusList entity:iostDeliverstatusListList) {
				//外键设置
				entity.setDeliverstatusId(iostDeliverstatus.getId());
				iostDeliverstatusListMapper.insert(entity);
			}
		}
	}

	@Override
	@Transactional
	public void updateMain(IostDeliverstatus iostDeliverstatus,List<IostDeliverstatusList> iostDeliverstatusListList) {
		iostDeliverstatusMapper.updateById(iostDeliverstatus);
		
		//1.先删除子表数据
		iostDeliverstatusListMapper.deleteByMainId(iostDeliverstatus.getId());
		
		//2.子表数据重新插入
		if(iostDeliverstatusListList!=null && iostDeliverstatusListList.size()>0) {
			for(IostDeliverstatusList entity:iostDeliverstatusListList) {
				//外键设置
				entity.setDeliverstatusId(iostDeliverstatus.getId());
				iostDeliverstatusListMapper.insert(entity);
			}
		}
	}

	@Override
	@Transactional
	public void delMain(String id) {
		iostDeliverstatusListMapper.deleteByMainId(id);
		iostDeliverstatusMapper.deleteById(id);
	}

	@Override
	@Transactional
	public void delBatchMain(Collection<? extends Serializable> idList) {
		for(Serializable id:idList) {
			iostDeliverstatusListMapper.deleteByMainId(id.toString());
			iostDeliverstatusMapper.deleteById(id);
		}
	}
	
}
