package org.jeecg.modules.iost.basedata.service.impl;

import org.jeecg.modules.iost.basedata.entity.IostDeliveryNote;
import org.jeecg.modules.iost.basedata.entity.IostDeliveryRecord4Pics;
import org.jeecg.modules.iost.basedata.entity.IostDeliveryNoteList;
import org.jeecg.modules.iost.basedata.mapper.IostDeliveryRecord4PicMapper;
import org.jeecg.modules.iost.basedata.mapper.IostDeliveryNoteListMapper;
import org.jeecg.modules.iost.basedata.mapper.IostDeliveryNoteMapper;
import org.jeecg.modules.iost.basedata.service.IIostDeliveryNoteService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import java.io.Serializable;
import java.util.List;
import java.util.Collection;

/**
 * @Description: delivery note
 * @Author: jeecg-boot
 * @Date:   2020-11-20
 * @Version: V1.0
 */
@Service
public class IostDeliveryNoteServiceImpl extends ServiceImpl<IostDeliveryNoteMapper, IostDeliveryNote> implements IIostDeliveryNoteService {

	@Autowired
	private IostDeliveryRecord4PicMapper iostDeliveryNote4PicMapper;
	@Autowired
	private IostDeliveryNoteMapper iostDeliveryNoteMapper;
	@Autowired
	private IostDeliveryNoteListMapper iostDeliveryNoteListMapper;
	
	@Override
	@Transactional
	public void saveMain(IostDeliveryNote iostDeliveryNote, List<IostDeliveryNoteList> iostDeliveryNoteListList) {
		iostDeliveryNoteMapper.insert(iostDeliveryNote);
		if(iostDeliveryNoteListList!=null && iostDeliveryNoteListList.size()>0) {
			for(IostDeliveryNoteList entity:iostDeliveryNoteListList) {
				//外键设置
				entity.setDeliveryNoteId(iostDeliveryNote.getId());
				iostDeliveryNoteListMapper.insert(entity);
			}
		}
	}

	@Override
	public void updateMain4Pic(IostDeliveryRecord4Pics iostDeliveryNote) {
		// TODO Auto-generated method stub
		iostDeliveryNote4PicMapper.updateById(iostDeliveryNote);
	}

	@Override
	public IostDeliveryRecord4Pics queryById4Pic(String id) {
		// TODO Auto-generated method stub
		return iostDeliveryNote4PicMapper.selectById(id);
	}

	@Override
	@Transactional
	public void updateMain(IostDeliveryNote iostDeliveryNote,List<IostDeliveryNoteList> iostDeliveryNoteListList) {
		iostDeliveryNoteMapper.updateById(iostDeliveryNote);
		
		//1.先删除子表数据
		iostDeliveryNoteListMapper.deleteByMainId(iostDeliveryNote.getId());
		
		//2.子表数据重新插入
		if(iostDeliveryNoteListList!=null && iostDeliveryNoteListList.size()>0) {
			for(IostDeliveryNoteList entity:iostDeliveryNoteListList) {
				//外键设置
				entity.setDeliveryNoteId(iostDeliveryNote.getId());
				iostDeliveryNoteListMapper.insert(entity);
			}
		}
	}

	@Override
	@Transactional
	public void delMain(String id) {
		iostDeliveryNoteListMapper.deleteByMainId(id);
		iostDeliveryNoteMapper.deleteById(id);
	}

	@Override
	@Transactional
	public void delBatchMain(Collection<? extends Serializable> idList) {
		for(Serializable id:idList) {
			iostDeliveryNoteListMapper.deleteByMainId(id.toString());
			iostDeliveryNoteMapper.deleteById(id);
		}
	}


}
