package org.jeecg.modules.iost.basedata.service.impl;

import org.jeecg.modules.iost.basedata.entity.DeliverySumSourceField;
import org.jeecg.modules.iost.basedata.entity.IostDeliveryRecordList;
import org.jeecg.modules.iost.basedata.entity.IostSummarySheetList;
import org.jeecg.modules.iost.basedata.mapper.IostDeliveryRecordListMapper;
import org.jeecg.modules.iost.basedata.service.IIostDeliveryRecordListService;
import org.springframework.stereotype.Service;
import java.util.List;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @Description: 出库记录表
 * @Author: jeecg-boot
 * @Date:   2020-12-07
 * @Version: V1.0
 */
@Service
public class IostDeliveryRecordListServiceImpl extends ServiceImpl<IostDeliveryRecordListMapper, IostDeliveryRecordList> implements IIostDeliveryRecordListService {
	
	@Autowired
	private IostDeliveryRecordListMapper iostDeliveryRecordListMapper;
	
	@Override
	public List<IostDeliveryRecordList> selectByMainId(String mainId) {
		return iostDeliveryRecordListMapper.selectByMainId(mainId);
	}

	@Override
	public List<DeliverySumSourceField> getSumSourceFields(List<String> sourceEntryIds) {
		// TODO Auto-generated method stub
		return iostDeliveryRecordListMapper.getSumSourceFields(sourceEntryIds);
	}

	@Override
	public List<IostSummarySheetList> getSummaryLists(String mainId) {
		// TODO Auto-generated method stub
		return iostDeliveryRecordListMapper.getSummaryLists(mainId);
	}
}
