package org.jeecg.modules.iost.basedata.service.impl;

import org.jeecg.modules.iost.basedata.entity.IostInventoryRecord;
import org.jeecg.modules.iost.basedata.entity.IostInventoryRecordList;
import org.jeecg.modules.iost.basedata.mapper.IostInventoryRecordListMapper;
import org.jeecg.modules.iost.basedata.mapper.IostInventoryRecordMapper;
import org.jeecg.modules.iost.basedata.service.IIostInventoryRecordService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import java.io.Serializable;
import java.util.List;
import java.util.Collection;

/**
 * @Description: 库存记录
 * @Author: jeecg-boot
 * @Date:   2020-11-10
 * @Version: V1.0
 */
@Service
public class IostInventoryRecordServiceImpl extends ServiceImpl<IostInventoryRecordMapper, IostInventoryRecord> implements IIostInventoryRecordService {

	@Autowired
	private IostInventoryRecordMapper iostInventoryRecordMapper;
	@Autowired
	private IostInventoryRecordListMapper iostInventoryRecordListMapper;
	
	@Override
	@Transactional
	public void saveMain(IostInventoryRecord iostInventoryRecord, List<IostInventoryRecordList> iostInventoryRecordListList) {
		iostInventoryRecordMapper.insert(iostInventoryRecord);
		if(iostInventoryRecordListList!=null && iostInventoryRecordListList.size()>0) {
			for(IostInventoryRecordList entity:iostInventoryRecordListList) {
				//外键设置
				entity.setRecordId(iostInventoryRecord.getId());
				iostInventoryRecordListMapper.insert(entity);
			}
		}
	}

	@Override
	@Transactional
	public void updateMain(IostInventoryRecord iostInventoryRecord,List<IostInventoryRecordList> iostInventoryRecordListList) {
		iostInventoryRecordMapper.updateById(iostInventoryRecord);
		
		//1.先删除子表数据
		iostInventoryRecordListMapper.deleteByMainId(iostInventoryRecord.getId());
		
		//2.子表数据重新插入
		if(iostInventoryRecordListList!=null && iostInventoryRecordListList.size()>0) {
			for(IostInventoryRecordList entity:iostInventoryRecordListList) {
				//外键设置
				entity.setRecordId(iostInventoryRecord.getId());
				iostInventoryRecordListMapper.insert(entity);
			}
		}
	}

	@Override
	@Transactional
	public void delMain(String id) {
		iostInventoryRecordListMapper.deleteByMainId(id);
		iostInventoryRecordMapper.deleteById(id);
	}

	@Override
	@Transactional
	public void delBatchMain(Collection<? extends Serializable> idList) {
		for(Serializable id:idList) {
			iostInventoryRecordListMapper.deleteByMainId(id.toString());
			iostInventoryRecordMapper.deleteById(id);
		}
	}
	
}
