package org.jeecg.modules.iost.basedata.service.impl;

import org.jeecg.modules.iost.basedata.entity.IostReceiving;
import org.jeecg.modules.iost.basedata.entity.IostReceivinglist;
import org.jeecg.modules.iost.basedata.mapper.IostReceivinglistMapper;
import org.jeecg.modules.iost.basedata.mapper.IostReceivingMapper;
import org.jeecg.modules.iost.basedata.service.IIostReceivingService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import java.io.Serializable;
import java.util.List;
import java.util.Collection;

/**
 * @Description: 入仓单
 * @Author: jeecg-boot
 * @Date:   2020-11-16
 * @Version: V1.0
 */
@Service
public class IostReceivingServiceImpl extends ServiceImpl<IostReceivingMapper, IostReceiving> implements IIostReceivingService {

	@Autowired
	private IostReceivingMapper iostReceivingMapper;
	@Autowired
	private IostReceivinglistMapper iostReceivinglistMapper;
	
	@Override
	@Transactional
	public void saveMain(IostReceiving iostReceiving, List<IostReceivinglist> iostReceivinglistList) {
		iostReceivingMapper.insert(iostReceiving);
		if(iostReceivinglistList!=null && iostReceivinglistList.size()>0) {
			for(IostReceivinglist entity:iostReceivinglistList) {
				//外键设置
				entity.setReceivingId(iostReceiving.getId());
				iostReceivinglistMapper.insert(entity);
			}
		}
	}

	@Override
	@Transactional
	public IostReceiving getByIdPrint(String id) {
		return iostReceivingMapper.getByIdPrint(id);
	}

	@Override
	@Transactional
	public void updateMain(IostReceiving iostReceiving,List<IostReceivinglist> iostReceivinglistList) {
		iostReceivingMapper.updateById(iostReceiving);
		
		//1.先删除子表数据
		iostReceivinglistMapper.deleteByMainId(iostReceiving.getId());
		
		//2.子表数据重新插入
		if(iostReceivinglistList!=null && iostReceivinglistList.size()>0) {
			for(IostReceivinglist entity:iostReceivinglistList) {
				//外键设置
				entity.setReceivingId(iostReceiving.getId());
				iostReceivinglistMapper.insert(entity);
			}
		}
	}

	@Override
	@Transactional
	public void delMain(String id) {
		iostReceivinglistMapper.deleteByMainId(id);
		iostReceivingMapper.deleteById(id);
	}

	@Override
	@Transactional
	public void delBatchMain(Collection<? extends Serializable> idList) {
		for(Serializable id:idList) {
			iostReceivinglistMapper.deleteByMainId(id.toString());
			iostReceivingMapper.deleteById(id);
		}
	}
	
}
