package org.jeecg.modules.iost.basedata.service.impl;

import org.jeecg.modules.iost.basedata.entity.IostSummarySheet;
import org.jeecg.modules.iost.basedata.entity.IostSummarySheetList;
import org.jeecg.modules.iost.basedata.mapper.IostSummarySheetListMapper;
import org.jeecg.modules.iost.basedata.mapper.IostSummarySheetMapper;
import org.jeecg.modules.iost.basedata.service.IIostSummarySheetService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import java.io.Serializable;
import java.util.List;
import java.util.Collection;

/**
 * @Description: 汇总单
 * @Author: jeecg-boot
 * @Date:   2020-12-22
 * @Version: V1.0
 */
@Service
public class IostSummarySheetServiceImpl extends ServiceImpl<IostSummarySheetMapper, IostSummarySheet> implements IIostSummarySheetService {

	@Autowired
	private IostSummarySheetMapper iostSummarySheetMapper;
	@Autowired
	private IostSummarySheetListMapper iostSummarySheetListMapper;
	
	@Override
	@Transactional
	public void saveMain(IostSummarySheet iostSummarySheet, List<IostSummarySheetList> iostSummarySheetListList) {
		iostSummarySheetMapper.insert(iostSummarySheet);
		if(iostSummarySheetListList!=null && iostSummarySheetListList.size()>0) {
			for(IostSummarySheetList entity:iostSummarySheetListList) {
				//外键设置
				entity.setSummaryId(iostSummarySheet.getId());
				iostSummarySheetListMapper.insert(entity);
			}
		}
	}

	@Override
	@Transactional
	public void updateMain(IostSummarySheet iostSummarySheet,List<IostSummarySheetList> iostSummarySheetListList) {
		iostSummarySheetMapper.updateById(iostSummarySheet);
		
		//1.先删除子表数据
		iostSummarySheetListMapper.deleteByMainId(iostSummarySheet.getId());
		
		//2.子表数据重新插入
		if(iostSummarySheetListList!=null && iostSummarySheetListList.size()>0) {
			for(IostSummarySheetList entity:iostSummarySheetListList) {
				//外键设置
				entity.setSummaryId(iostSummarySheet.getId());
				iostSummarySheetListMapper.insert(entity);
			}
		}
	}

	@Override
	@Transactional
	public void delMain(String id) {
		iostSummarySheetListMapper.deleteByMainId(id);
		iostSummarySheetMapper.deleteById(id);
	}

	@Override
	@Transactional
	public void delBatchMain(Collection<? extends Serializable> idList) {
		for(Serializable id:idList) {
			iostSummarySheetListMapper.deleteByMainId(id.toString());
			iostSummarySheetMapper.deleteById(id);
		}
	}
	
}
