package org.jeecg.modules.iost.basedata.vo;

import java.util.List;
import org.jeecg.modules.iost.basedata.entity.IostDeliveryNote;
import org.jeecg.modules.iost.basedata.entity.IostDeliveryNoteList;
import lombok.Data;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecgframework.poi.excel.annotation.ExcelEntity;
import org.jeecgframework.poi.excel.annotation.ExcelCollection;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import java.util.Date;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @Description: delivery note
 * @Author: jeecg-boot
 * @Date:   2020-11-20
 * @Version: V1.0
 */
@Data
@ApiModel(value="iost_delivery_notePage对象", description="delivery note")
public class IostDeliveryNotePage {

	/**主键*/
	@ApiModelProperty(value = "主键")
	private java.lang.String id;
	/**创建人*/
	@ApiModelProperty(value = "创建人")
	private java.lang.String createBy;
	/**创建日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
	@ApiModelProperty(value = "创建日期")
	private java.util.Date createTime;
	/**更新人*/
	@ApiModelProperty(value = "更新人")
	private java.lang.String updateBy;
	/**更新日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
	@ApiModelProperty(value = "更新日期")
	private java.util.Date updateTime;
	/**所属部门*/
	@ApiModelProperty(value = "所属部门")
	private java.lang.String sysOrgCode;
	/**Contact Name*/
	@Excel(name = "Contact Name", width = 15)
	@ApiModelProperty(value = "Contact Name")
	private java.lang.String contactName;
	/**Date*/
	@Excel(name = "Date", width = 15, format = "yyyy-MM-dd")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
	@ApiModelProperty(value = "Date")
	private java.util.Date date;
	/**Phone No.*/
	@Excel(name = "Phone No.", width = 15)
	@ApiModelProperty(value = "Phone No.")
	private java.lang.String phoneNo;
	/**Reference*/
	@Excel(name = "Reference", width = 15)
	@ApiModelProperty(value = "Reference")
	private java.lang.String reference;
	/**Company*/
	@Excel(name = "Company", width = 15)
	@ApiModelProperty(value = "Company")
	private java.lang.String company;
	/**Address*/
	@Excel(name = "Address", width = 15)
	@ApiModelProperty(value = "Address")
	private java.lang.String address;

	@ExcelCollection(name="delivery_note_list")
	@ApiModelProperty(value = "delivery_note_list")
	private List<IostDeliveryNoteList> iostDeliveryNoteListList;

}
