package org.jeecg.modules.iost.basedata.vo;

import java.util.List;
import org.jeecg.modules.iost.basedata.entity.IostReceiving;
import org.jeecg.modules.iost.basedata.entity.IostReceivinglist;
import lombok.Data;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecgframework.poi.excel.annotation.ExcelEntity;
import org.jeecgframework.poi.excel.annotation.ExcelCollection;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import java.util.Date;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @Description: 入仓单
 * @Author: jeecg-boot
 * @Date:   2020-12-17
 * @Version: V1.0
 */
@Data
@ApiModel(value="iost_receivingPage对象", description="入仓单")
public class IostReceivingPage {

	/**主键*/
	@ApiModelProperty(value = "主键")
	private java.lang.String id;
	/**创建人*/
	@ApiModelProperty(value = "创建人")
	private java.lang.String createBy;
	/**创建日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
	@ApiModelProperty(value = "创建日期")
	private java.util.Date createTime;
	/**更新人*/
	@ApiModelProperty(value = "更新人")
	private java.lang.String updateBy;
	/**更新日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
	@ApiModelProperty(value = "更新日期")
	private java.util.Date updateTime;
	/**所属部门*/
	@ApiModelProperty(value = "所属部门")
	private java.lang.String sysOrgCode;
	/**入仓号*/
	@Excel(name = "入仓号", width = 15)
	@ApiModelProperty(value = "入仓号")
	private java.lang.String receivingNo;
	/**送货厂家*/
	@Excel(name = "送货厂家", width = 15)
	@ApiModelProperty(value = "送货厂家")
	private java.lang.String deliveryFactory;
	/**仓库名称*/
	@Excel(name = "仓库名称", width = 15, dictTable = "iost_storage", dicText = "name", dicCode = "id")
    @Dict(dictTable = "iost_storage", dicText = "name", dicCode = "id")
	@ApiModelProperty(value = "仓库名称")
	private java.lang.String warehouseName;
	/**客户姓名*/
	@Excel(name = "客户姓名", width = 15)
	@ApiModelProperty(value = "客户姓名")
	private java.lang.String customerName;
	/**送货人*/
	@Excel(name = "送货人", width = 15)
	@ApiModelProperty(value = "送货人")
	private java.lang.String deliveryMan;
	/**总件数*/
	@Excel(name = "总件数", width = 15)
	@ApiModelProperty(value = "总件数")
	private java.lang.Integer casesTotal;
	/**客户编码*/
	@Excel(name = "客户编码", width = 15)
	@ApiModelProperty(value = "客户编码")
	private java.lang.String customerCode;
	/**联系电话*/
	@Excel(name = "联系电话", width = 15)
	@ApiModelProperty(value = "联系电话")
	private java.lang.String telephone;
	/**入库日期*/
	@Excel(name = "入库日期", width = 15, format = "yyyy-MM-dd")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
	@ApiModelProperty(value = "入库日期")
	private java.util.Date date;
	/**总体积*/
	@Excel(name = "总体积", width = 15)
	@ApiModelProperty(value = "总体积")
	private java.lang.Double volumesTotal;
	/**总重量*/
	@Excel(name = "总重量", width = 15)
	@ApiModelProperty(value = "总重量")
	private java.lang.Double weightsTotal;

	@ExcelCollection(name="入仓列表")
	@ApiModelProperty(value = "入仓列表")
	private List<IostReceivinglist> iostReceivinglistList;

}
