package org.jeecg.modules.system.rule;

import java.util.List;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import org.jeecg.common.handler.IFillRuleHandler;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.YouBianCodeUtil;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.iost.basedata.entity.IostReceivingNote;
import org.jeecg.modules.iost.basedata.mapper.IostReceivingNoteMapper;
import org.jeecg.modules.system.entity.SysCategory;
import org.jeecg.modules.system.mapper.SysCategoryMapper;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;

public class ReceivingNoteRule implements IFillRuleHandler {

    public static final String ROOT_PID_VALUE = "PX";
	@Override
	public Object execute(JSONObject params, JSONObject formData) {

        String categoryPid = ROOT_PID_VALUE;
        String bulk_no = "";

        if (formData != null && formData.size() > 0) {
            Object obj = formData.get("bulk_no");
            if(oConvertUtils.isNotEmpty(obj)) bulk_no = obj.toString();
        }
        
        if (params != null) {
            Object obj = params.get("pid");
            if (oConvertUtils.isNotEmpty(obj)) categoryPid = obj.toString();
        }
        LambdaQueryWrapper<IostReceivingNote> query = new LambdaQueryWrapper<IostReceivingNote>().orderByDesc(IostReceivingNote::getId);
        IostReceivingNoteMapper baseMapper = (IostReceivingNoteMapper) SpringContextUtils.getBean("IostReceivingNoteMapper");
        List<IostReceivingNote> list = baseMapper.selectList(query);
        String categoryCode = categoryPid + "_" + bulk_no + "_1";
		// TODO Auto-generated method stub
        if (list != null && list.size() > 0) {
            categoryCode = YouBianCodeUtil.getNextYouBianCode(list.get(0).getReceivingNo());
        }
		return categoryCode;
	}

}
