package org.jeecg;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import kingdee.bos.webapi.client.K3CloudApiClient;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.jeecg.common.util.security.SecurityTools;
import org.jeecg.common.util.security.entity.*;

import org.jeecg.modules.iost.API.dto.kingdee.KingDeeReturn;

import org.jeecg.modules.iost.API.dto.kingdee.Result;
import org.junit.Test;
import org.springframework.scheduling.annotation.EnableScheduling;


import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@Slf4j
@EnableScheduling
public class SecurityToolsTest {
    static String K3CloudURL = "http://134.175.224.100/k3cloud/";//指定地址
    static String dbId = "6131d9fcd30ee9";
    static String uid = "kingdee";
    static String pwd = "kingdee@999";
    static int lang = 2052;
    K3CloudApiClient client = new K3CloudApiClient(K3CloudURL);

    @Test
    public void Test() {
        MyKeyPair mkeyPair = SecurityTools.generateKeyPair();

        JSONObject msg = new JSONObject();
        msg.put("name", "党政辉");
        msg.put("age", 50);
        JSONObject identity = new JSONObject();
        identity.put("type", "01");
        identity.put("no", "210882165896524512");
        msg.put("identity", identity);

        // 签名加密部分
        SecuritySignReq signReq = new SecuritySignReq();
        // data为要加密的报文字符串
        signReq.setData(msg.toString());
        // 为rsa私钥
        signReq.setPrikey(mkeyPair.getPriKey());
        // 调用签名方法
        SecuritySignResp sign = SecurityTools.sign(signReq);
        // 打印出来加密数据
        // signData为签名数据
        // data为aes加密数据
        // asekey为ras加密过的aeskey
        //System.out.println(new JSONObject(sign).toStringPretty());

        // 验签解密部分
        SecurityReq req = new SecurityReq();
        //对方传过来的数据一一对应
        req.setAesKey(sign.getAesKey());
        req.setData(sign.getData());
        req.setSignData(sign.getSignData());
        //我们的公钥
        req.setPubKey(mkeyPair.getPubKey());
        //验签方法调用
        SecurityResp securityResp = SecurityTools.valid(req);
        //解密报文data为解密报文
        //sucess 为验签成功失败标志 true代码验签成功，false代表失败
        // System.out.println(new JSONObject(securityResp).toStringPretty());
    }


    @Test
    public void getTransno() throws IOException {
        String s = "{\"Result\":{\"ResponseStatus\":{\"ErrorCode\":500,\"IsSuccess\":false,\"Errors\":[{\"FieldName\":\"FMaterialId\",\"Message\":\"单据体“订单明细”第1行字段“物料编码”是必填项\",\"DIndex\":0},{\"FieldName\":\"FUnitID\",\"Message\":\"单据体“订单明细”第1行字段“销售单位”是必填项\",\"DIndex\":0},{\"FieldName\":\"FPriceUnitId\",\"Message\":\"单据体“订单明细”第1行字段“计价单位”是必填项\",\"DIndex\":0},{\"FieldName\":\"FStockUnitID\",\"Message\":\"单据体“订单明细”第1行字段“库存单位”是必填项\",\"DIndex\":0}],\"SuccessEntitys\":[],\"SuccessMessages\":[],\"MsgCode\":11},\"Id\":\"\",\"Number\":\"\",\"NeedReturnData\":[{}]}}";


//        boolean equals = kingDeeReturn.equals(null);
        try {
            KingDeeReturn kingDeeReturn = JSON.parseObject(s, KingDeeReturn.class, Feature.OrderedField);
            System.out.println(kingDeeReturn);
            if (null != kingDeeReturn && null != kingDeeReturn.getResult()) {
                Result result = kingDeeReturn.getResult();
                if (!result.getId().equals("") && !result.getNumber().equals("")) {
                    System.out.println(1);
                }

            } else {

            }
        } catch (Exception e) {

        }


//        return transno;
    }

    @Test
    public void ad() {
        List objects = new ArrayList<>();
//        objects=null;
        System.out.println(objects.size());
        for (int i = 0; i < objects.size(); i++) {
            System.out.println(1);
//            System.out.println(object);
        }

    }
}
