package org.jeecg.modules.iost.API.Dao;


import kingdee.bos.webapi.client.K3CloudApiClient;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.modules.iost.API.Util.HttpUtil;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * WEB-API
 */
@Slf4j
@Component
@Scope("prototype")
public class CategoryDao {
    //    static String K3CloudURL = "http://192.168.2.243/k3cloud/";//指定地址
//    static String dbId = "6136b7c51f0e4f";
//    static String uid = "Administrator";
//    static String pwd = "888888";
//    static int lang = 2052;https://192.168.6.16/k3cloud/
    static String K3CloudURL = "http://192.168.6.16/k3cloud/";//指定地址
    static String dbId = "6017c3fce822bf";
    static String uid = "kingdee";
    static String pwd = "123456";
    static int lang = 2052;
    K3CloudApiClient client = new K3CloudApiClient(K3CloudURL);

    private String Stringwhere(Map<String, String> map) {
        String where = null;
        for (String key : map.keySet()) {
            String value = String.valueOf(map.get(key));
            if (value != null && value != "") {
                if (where != null) {
                    where = where + " AND " + key + "=" + value;
                } else {
                    where = key + "=" + value + "";
                }
            }
        }
        if (where != null) {
            return ",\"FilterString\":\"" + where + "\"";
        }
        return "";
    }


    private String Stringkey(Map<String, String> map) {
        String Keys = null;
        for (String key : map.keySet()) {
            String value = String.valueOf(map.get(key));
            if (value != null && value != "") {
                if (Keys != null) {
                    Keys = Keys + " , " + key;
                } else {
                    Keys = key;
                }
            }
        }
        if (Keys != null) {
            return "\"FieldKeys\":\"" + Keys + "\"";
        }
        return "";
    }

    private String StringCompareIn(Map<String, String> map) {
        String where = null;
        for (String key : map.keySet()) {
            String value = String.valueOf(map.get(key));
            if (value != null && value != "") {
                if (where != null) {
                    where = where + "," + value;
                } else {
                    where = key + " in (" + value + "";
                }
            }
        }
        if (where != null) {
            return ",\"FilterString\":\"" + where + ")\"";
        }
        return "";
    }

    public String add(String sFormId, String json) {
        String result2 = null;
        try {
            Boolean result = client.login(dbId, uid, pwd, lang);
            if (result) {
                String content = "{\"Model\":" + json + "}";
                result2 = client.save(sFormId, content);

            }
        } catch (Exception e) {
            log.debug(String.valueOf(e));
        }
        return result2;
    }

    public String batchAdd(String sFormId, String Listjson) {
        String result2 = null;
        try {
            Boolean result = client.login(dbId, uid, pwd, lang);
            if (result) {
                String content = "{\"Model\":" + Listjson + "}";
                result2 = client.batchSave(sFormId, content);
            }
        } catch (Exception e) {
            log.debug(String.valueOf(e));
        }
        return result2;
    }

    /**
     * 查询单据体
     *
     * @return
     * @throws Exception
     */
    public List<List<Object>> select(String sFormId, Map<String, String> key, Map<String, String> where) {
        List<List<Object>> list = null;
        try {
            Boolean result = client.login(dbId, uid, pwd, lang);
            if (result) {
                String content;
                if (where != null) {
                    content = "{\"FormId\":\"" + sFormId + "\"," + Stringkey(key) + Stringwhere(where) + "}";
                } else {
                    content = "{\"FormId\":\"" + sFormId + "\"," + Stringkey(key) + "}";
                }
                list = client.executeBillQuery(content);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public List<List<Object>> selectIn(String sFormId, Map<String, String> key, Map<String, String> where) {
        List<List<Object>> list = null;
        try {
            Boolean result = client.login(dbId, uid, pwd, lang);
            if (result) {
                String content;
                if (where != null) {
                    content = "{\"FormId\":\"" + sFormId + "\"," + Stringkey(key) + StringCompareIn(where) + "}";
                } else {
                    content = "{\"FormId\":\"" + sFormId + "\"," + Stringkey(key) + "}";
                }
                list = client.executeBillQuery(content);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public Map<String, List<List<Object>>> selectMapWhereMap(String sFormId, Map<String, String> key, Map<String, String> where) {
        List<List<Object>> list = null;
        Map<String, List<List<Object>>> stringListHashMap = new HashMap<String, List<List<Object>>>();
        try {
            Boolean result = client.login(dbId, uid, pwd, lang);
            if (result) {
                String content;
                if (where != null) {
                    content = "{\"FormId\":\"" + sFormId + "\"," + Stringkey(key) + Stringwhere(where) + "}";
                } else {
                    content = "{\"FormId\":\"" + sFormId + "\"," + Stringkey(key) + "}";
                }
                list = client.executeBillQuery(content);
                stringListHashMap.put(content, list);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return stringListHashMap;
    }

    public Map<String, List<List<Object>>> selectMapWhereString(String sFormId, Map<String, String> key, String where) {
        List<List<Object>> list = null;
        Map<String, List<List<Object>>> stringListHashMap = new HashMap<String, List<List<Object>>>();
        try {
            Boolean result = client.login(dbId, uid, pwd, lang);
            if (result) {
                String content;
                if (where != null) {
                    content = "{\"FormId\":\"" + sFormId + "\"," + Stringkey(key) + ",\"FilterString\":\"" + where + "\"" + "}";
                } else {
                    content = "{\"FormId\":\"" + sFormId + "\"," + Stringkey(key) + "}";
                }
                list = client.executeBillQuery(content);
                stringListHashMap.put(content, list);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return stringListHashMap;
    }

    public String updateInMap(String sFormId, String Listjson) {
        String result2 = null;
        try {
            Boolean result = client.login(dbId, uid, pwd, lang);
            if (result) {
                String content = "{\"Model\":" + Listjson + "}";
                result2 = client.batchSave(sFormId, content);
                System.out.println("content " +
                        "" + content);
                System.out.println("result    " +
                        "" + result);
            }
        } catch (Exception e) {
            log.debug(String.valueOf(e));
        }
        return result2;
    }

    /**
     *
     *检查字段是否有该值（循环调用专用）
     * @return
     * @throws Exception
     */
    public List<Object> checkFiled(String sFormId, Map<String, String> key, Map<String, String> where, Map<String, K3CloudApiClient>  clientMap) {
        List<List<Object>> list = null;
        List<Object> objects=null;
        Boolean result = false;
        try {
            K3CloudApiClient clientTwo=null;
            if (null != clientMap.get("clientTwo")) {
                clientTwo=clientMap.get("clientTwo");
                result = true;
            } else {
                result = client.login(dbId, uid, pwd, lang);
                clientTwo = client;
                clientMap.put("clientTwo",client);
            }
            if (result) {
                String content;
                if (where != null) {
                    content = "{\"FormId\":\"" + sFormId + "\"," + Stringkey(key) + Stringwhere(where) + "}";
                } else {
                    content = "{\"FormId\":\"" + sFormId + "\"," + Stringkey(key) + "}";
                }
                list = clientTwo.executeBillQuery(content);
            }
            if (list.size()>0) {
                objects = list.get(0);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return objects;
    }
}

