package org.jeecg.modules.iost.API.Dao;

import kingdee.bos.webapi.client.K3CloudApiClient;
import lombok.extern.slf4j.Slf4j;
import org.hibernate.event.spi.SaveOrUpdateEvent;
import org.jeecg.modules.iost.API.Util.HttpUtil;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@Component
@Scope("prototype")
public class CategoryDaoSql {
    //    static String K3CloudURL = "http://192.168.2.243/k3cloud/";//指定地址
//    static String dbId = "6136b7c51f0e4f";
//    static String uid = "Administrator";
//    static String pwd = "888888";
//    static int lang = 2052;
    static String K3CloudURL = "http://192.168.6.16/k3cloud/";//指定地址
    static String dbId = "6017c3fce822bf";
    static String uid = "kingdee";
    static String pwd = "123456";
    static int lang = 2052;
    K3CloudApiClient client = new K3CloudApiClient(K3CloudURL);
    String servicenameTable = "LQKJ.WebApi.Stub.CustomWebApiService.ExecutDataSet,LQKJ.WebApi.Stub";
    String servicenameMap = "LQKJ.WebApi.Stub.CustomWebApiService.ExecuteDynamicObject,LQKJ.WebApi.Stub";
    String updateService = "LQKJ.WebApi.Stub.CustomWebApiService.ExecutBatch,LQKJ.WebApi.Stub";

    private String StringkeyMap(Map<String, String> map) {
        String Keys = null;
        for (String key : map.keySet()) {
            String value = String.valueOf(key);
            if (value != null && value != "") {
                if (Keys != null) {
                    Keys = Keys + " , " + key;
                } else {
                    Keys = key;
                }
            }
        }
        if (Keys != null) {
            return Keys;
        }
        return "";
    }

    private String StringWhereCompare(Map<String, String> map) {
        String where = null;
        for (String key : map.keySet()) {
            String value = String.valueOf(map.get(key));
            if (value != null && value != "") {
                if (where != null) {
                    where = where + " AND " + key + value;
                } else {
                    where = key + "" + value + "";
                }
            }
        }
        if (where != null) {
            return " where " + where + "";
        }
        return "";
    }

    private String StringOrCompare(Map<String, String> map) {
        String where = null;
        for (String key : map.keySet()) {
            String value = String.valueOf(map.get(key));
            if (value != null && value != "") {
                if (where != null) {
                    where = where + " OR " + key + value;
                } else {
                    where = key + "" + value + "";
                }
            }
        }
        if (where != null) {
            return " where " + where + "";
        }
        return "";
    }

    private String StringCompareIn(Map<String, String> map) {
        String where = null;
        for (String key : map.keySet()) {
            String value = String.valueOf(map.get(key));
            if (value != null && value != "") {
                if (where != null) {
                    where = where + "," + value;
                } else {
                    where = key + " in (" + value + "";
                }
            }
        }
        if (where != null) {
            return " where " + where + ")";
        }
        return "";
    }

    private String updateSetMap(Map<String, String> map) {
        String Keys = null;
        for (String key : map.keySet()) {
            String value = String.valueOf(key);
            if (value != null && value != "") {
                if (Keys != null) {
                    Keys = Keys + " , " + key + " = " + "'" + map.get(key) + "'";
                } else {
                    Keys = key + " = " + "'" + map.get(key) + "'";
                }
            }
        }
        if (Keys != null) {
            return Keys;
        }
        return "";
    }

    public Map<String, List<Map>> selectInMap(String f_sFormId, Map<String, String> key, Map<String, String> where) {
        Map<String, List<Map>> log = new HashMap<>();//返回k请求v相应
        String content = null;//请求
        List<Map> list = null;//响应
        try {
            Boolean result = client.login(dbId, uid, pwd, lang);
            if (result) {
                if (where != null) {
                    content = "SELECT top 100 " + StringkeyMap(key) + " FROM " + f_sFormId + StringWhereCompare(where) + ";";

                } else {
                    content = "SELECT top 100 " + StringkeyMap(key) + " FROM " + f_sFormId + ";";

                }


                String[] strings = new String[]{content};
                System.out.println("content " + content);
                list = client.execute(servicenameMap, strings, List.class);
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            log.put(content, list);//请求数据做key,返回做value
        }
        return log;
    }

    public Map<String, List<Map>> selectInMapOR(String f_sFormId, Map<String, String> key, Map<String, String> where) {
        Map<String, List<Map>> log = new HashMap<>();//返回k请求v相应
        String content = null;//请求
        List<Map> list = null;//响应
        try {
            Boolean result = client.login(dbId, uid, pwd, lang);
            if (result) {
                if (where != null) {
                    content = "SELECT " + StringkeyMap(key) + " FROM " + f_sFormId + StringOrCompare(where) + ";";
                } else {
                    content = "SELECT " + StringkeyMap(key) + " FROM " + f_sFormId + ";";
                }
                String[] strings = new String[]{content};
                list = client.execute(servicenameMap, strings, List.class);
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            log.put(content, list);//请求数据做key,返回做value
        }
        return log;
    }

    public Map<String, List<Map>> selectMapIn(String f_sFormId, Map<String, String> key, Map<String, String> where) {
        Map<String, List<Map>> log = new HashMap<>();//返回k请求v相应
        String content = null;//请求
        List<Map> list = null;//响应
        try {
            Boolean result = client.login(dbId, uid, pwd, lang);
            if (result) {
                if (where != null) {
                    content = "SELECT top 100 " + StringkeyMap(key) + " FROM " + f_sFormId + StringCompareIn(where) + ";";
                } else {
                    content = "SELECT top 100 " + StringkeyMap(key) + " FROM " + f_sFormId + ";";
                }
                String[] strings = new String[]{content};
                list = client.execute(servicenameMap, strings, List.class);
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            log.put(content, list);//请求数据做key,返回做value
        }
        return log;
    }

    public List<Map> selectIn(String f_sFormId, Map<String, String> key, Map<String, String> where) {
        String content = null;//请求
        List<Map> list = null;//响应
        try {
            Boolean result = client.login(dbId, uid, pwd, lang);
            if (result) {
                if (where != null) {
                    content = "SELECT top 100 " + StringkeyMap(key) + " FROM " + f_sFormId + StringCompareIn(where) + ";";
                } else {
                    content = "SELECT top 100 " + StringkeyMap(key) + " FROM " + f_sFormId + ";";
                }
                String[] strings = new String[]{content};
                list = client.execute(servicenameMap, strings, List.class);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public Map<String, Object> updateInMap(String f_sFormId, Map<String, String> set, Map<String, String> where) {
        Map<String, Object> log = new HashMap<>();//返回k请求v相应
        String content = null;//请求
        Object list = null;//响应
        try {
            content = "UPDATE " + f_sFormId + " SET " + updateSetMap(set) + " " + StringCompareIn(where);
            Map<String, String> hreader = new HashMap<>();
            hreader.put("Cookie", "ASP.NET_SessionId=w1um3b2stpbkovaacfz55oh1; kdservice-sessionid=fb84160d-d8e3-4d21-bcf7-3fc9e2851837");
            hreader.put("Cache-Control","no-cache");
            hreader.put("Content-Type","multipart/form-data; boundary=<calculated when request is sent>");
            hreader.put("Content-Length","<calculated when request is sent>");
            hreader.put("Host","<calculated when request is sent>");
            String finalContent = content;
            String url = K3CloudURL+"LQKJ.WebApi.Stub.CustomWebApiService.ExecutBatch,LQKJ.WebApi.Stub.common.kdsvc";
            list = HttpUtil.postForm(url, new HashMap<String, String>() {{
                put("sql", finalContent);
            }}, hreader);
            System.out.println("content "+content);
            System.out.println("list " + list);
        } catch (Exception e) {
            e.printStackTrace();
            System.out.println("Exception "+e);
        } finally {
            log.put(content, list);//请求数据做key,返回做value
        }
        return log;
    }

}
