package org.jeecg.modules.iost.API.Dao;


import kingdee.bos.webapi.client.K3CloudApiClient;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

import org.springframework.context.annotation.Scope;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;


import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * WEB-API
 */
@Slf4j
//@Component
//@Scope("prototype")
public class testDao {
    static String K3CloudURL = "http://192.168.2.243/k3cloud/";//指定地址
    static String dbId = "6136b7c51f0e4f";
    static String uid = "Administrator";
    static String pwd = "888888";
    static int lang = 2052;
    K3CloudApiClient client = new K3CloudApiClient(K3CloudURL);
    static String servicenameTable = "LQKJ.WebApi.Stub.CustomWebApiService.ExecutDataSet,LQKJ.WebApi.Stub";//返回表单
    static String servicenameMap = "LQKJ.WebApi.Stub.CustomWebApiService.ExecuteDynamicObject,LQKJ.WebApi.Stub";//返回字典
    static String updateService = "LQKJ.WebApi.Stub.CustomWebApiService.ExecutBatch,LQKJ.WebApi.Stub";//更新返回行数
    static String loginService = "Kingdee.BOS.WebApi.ServicesStub.AuthService.ValidateUser";//登录
    static String httpSuffix = ".common.kdsvc";//使用http所需要添加的后缀


    //金蝶WEBAPI请求服务基础样例，可做参照，请任意修改
    public List<Map> selectListOnMap(String sql) {
        String content = null;//请求
        List<Map> list = null;//响应
        try {
            Boolean result = client.login(dbId, uid, pwd, lang);
            if (result) {
                content = sql;
                String[] strings = new String[]{content};
                list = client.execute(servicenameMap, strings, List.class);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }


    //http请求服务基础样例，可做参照，请任意修改
    public void httpSql(String sql) {
        String loginUrl = K3CloudURL + loginService + httpSuffix;
        try {
            //获取登录后的连接，模拟一个浏览器站点
            CloseableHttpClient aDefault = getLinkCloseableHttpClient(loginUrl, loginValue());

            String urlstr = K3CloudURL + updateService + httpSuffix;
            HttpPost httpPost = new HttpPost(urlstr);
            List<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>() {{
                add(new BasicNameValuePair("sql", sql));
            }};
            UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(params, "UTF-8");
            httpPost.setEntity(urlEncodedFormEntity);
            CloseableHttpResponse closeableHttpResponse = null;
            try {
                closeableHttpResponse = aDefault.execute(httpPost);
                //获取响应结果
                HttpEntity entity = closeableHttpResponse.getEntity();
                String s2 = EntityUtils.toString(entity, StandardCharsets.UTF_8);
                //确保流关闭
                EntityUtils.consume(entity);

            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                if (aDefault != null) {
                    aDefault.close();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
        }
    }

    public CloseableHttpClient getLinkCloseableHttpClient(String loginUrl, String loginValue) {
        try {
            CloseableHttpClient linkCloseableHttpClient = HttpClients.createDefault();

            HttpPost httpPost = new HttpPost(loginUrl);
            List<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>() {{
                //value:["613ef0b02c911d","kingdee","123456",2052]
                add(new BasicNameValuePair("parameters", loginValue));
            }};
            UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(params, "UTF-8");
            httpPost.setEntity(urlEncodedFormEntity);
            CloseableHttpResponse closeableHttpResponse = null;
            try {
                closeableHttpResponse = linkCloseableHttpClient.execute(httpPost);
                //获取响应结果
                HttpEntity entity = closeableHttpResponse.getEntity();
                String s = EntityUtils.toString(entity, StandardCharsets.UTF_8);
                //确保流关闭
                EntityUtils.consume(entity);
                closeableHttpResponse.close();
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                if (linkCloseableHttpClient != null) {
                    return linkCloseableHttpClient;
                }

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return HttpClients.createDefault();
    }


    public String loginValue() {
        List value = new ArrayList() {{
            add(Escape(dbId));
            add(Escape(uid));
            add(Escape(pwd));
            add(lang);
        }};
        return value.toString();
    }

    public String Escape(String value) {
        return "\"" + value + "\"";
    }
}

