package org.jeecg.modules.iost.API.ExternalInterface;

import org.jeecg.modules.iost.API.ExternalInterface.Interface.API;
import org.jeecg.modules.iost.API.Util.HttpUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description: OA借款接口
 */
@Component
public class BusinessTripInterfaceApi implements API {

    @Value("${oa.url}")
    private String url;
//    private String url = "http://test.qywx.kingsware.cn";
    //https://qywx.kingsware.cn/OA/ERPAction.do?method=queryConcludeData&type=ER_ExpenseRequest&date=2021-11-13

    private Map<String, String> hreader = new HashMap<>();

    public BusinessTripInterfaceApi() {
//        hreader.put("Content-Type", "application/json");
    }

    @Override
    public String add(Map<String, String> map) {
        Map params = map;
        String result = HttpUtils.getRequest(url + "/OA/erpTravelAction.do", hreader, params);
        return result;
    }

    @Override
    public String select() {
        Map params = new HashMap() {{
            put("method", "queryConcludeData");
            put("type", "ER_ExpReimbursement_Travel");
        }};
        String result = HttpUtils.getRequest(url + "/OA/ERPAction.do", hreader, params);
        return result;
    }

    public String getSelect(Map params) {
        String result = HttpUtils.getRequest(url + "/OA/ERPAction.do", hreader, params);
        return result;
    }
    public String update(Map params) {
        String result = HttpUtils.getRequest(url + "/OA/ERPAction.do", hreader, params);
        return result;
    }
}
