package org.jeecg.modules.iost.API.ExternalInterface;

import lombok.val;
import org.jeecg.modules.iost.API.ExternalInterface.Interface.API;
import org.jeecg.modules.iost.API.Util.HttpUtil;
import org.jeecg.modules.iost.API.Util.HttpUtils;
import org.jeecg.modules.iost.API.Util.JsonUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.*;

/**
 * @Description: OA借款接口
 */
@Component
public class LoanInterfaceApi implements API {

    //    private String url = "http://test.qywx.kingsware.cn";//正式接口
    @Value("${oa.url}")
    private String url;

    private Map<String, String> hreader = new HashMap<>();

    public LoanInterfaceApi() {
//        hreader.put("Content-Type", "application/json");
    }

    @Override
    public String add(Map<String, String> map) {
        Map params = map;
        String result = HttpUtils.getRequest(url + "/OA/erpBorrowAction.do", hreader, params);
        return result;
    }

    @Override
    public String select() {
        Map params = new LinkedHashMap() {{
            put("method", "queryConcludeData");
            put("type", "ER_ExpenseRequest");
        }};
        String result = HttpUtils.getRequest(url + "/OA/ERPAction.do", hreader, params);
        return result;
    }

    public String getSelect(Map params) {
        String result = HttpUtils.getRequest(url + "/OA/ERPAction.do", hreader, params);
        return result;
    }

    public String update(Map params) {
        String result = HttpUtils.getRequest(url + "/OA/ERPAction.do", hreader, params);
        return result;
    }
}
