package org.jeecg.modules.iost.API.ExternalInterface;

import org.jeecg.modules.iost.API.ExternalInterface.Interface.API;
import org.jeecg.modules.iost.API.Util.HttpUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description: OA其他报销接口
 */
@Component
public class OtherReimbursementInterfaceApi implements API {

    @Value("${oa.url}")
    private String url;
//    private String url = "https://b02ba329-ac3e-4144-a744-25abca96b290.mock.pstmn.io/";

    private Map<String, String> hreader = new HashMap<>();

    public OtherReimbursementInterfaceApi() {
//        hreader.put("Content-Type", "application/json");
    }

    @Override
    public String add(Map<String, String> map) {
        Map params = map;
        String result = HttpUtils.getRequest(url + "/OA/otherExpensesAction.do", hreader, params);
        return result;
    }

    @Override
    public String select() {
        Map params = new HashMap() {{
            put("method", "queryConcludeData");
            put("type", "ER_ExpReimbursement");
        }};
        String result = HttpUtils.getRequest(url + "/OA/ERPAction.do", hreader, params);
        return result;
    }

    public String getSelect(Map params) {
        String result = HttpUtils.getRequest(url + "/OA/ERPAction.do", hreader, params);
        return result;
    }

    public String update(Map params) {
        String result = HttpUtils.getRequest(url + "/OA/ERPAction.do", hreader, params);
        return result;
    }
}
