package org.jeecg.modules.iost.API.TimedTask;

import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.modules.iost.API.service.ILQKJ_t_IMSSyncDetailsService;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.text.ParseException;

@Slf4j
@Component
@EnableScheduling
public class LQKJ_t_IMSSyncDetailsTimed implements Job {
    @Autowired
    private ILQKJ_t_IMSSyncDetailsService t_imsSyncDetailsService;

    /**
     * 测试定时
     */
//     @Scheduled(cron = "0 0 1 * * ?")//cron表达式每天凌晨一点
//    @Scheduled(fixedDelay = 1000 * 60 * 10)
    public void synchronization() throws IOException, ParseException {
        Object synchronization = t_imsSyncDetailsService.synchronization();
        System.out.println("执行了");
    }

    @SneakyThrows
    @Override
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        System.out.println("开始同步金蝶数据到本地");
        synchronized (this) {
            Object synchronization = t_imsSyncDetailsService.synchronization();
        }
        System.out.println("完成同步金蝶数据到本地");
    }
}
