package org.jeecg.modules.iost.API.TimedTask;

import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.modules.iost.API.service.ILoanDiscardDetailsService;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.text.ParseException;

@Slf4j
@Component
@EnableScheduling
public class LoanDiscardDetailsTimed implements Job {
    @Autowired
    private ILoanDiscardDetailsService loanDiscardDetailsService;

    /**
     * 测试定时
     */
//     @Scheduled(cron = "0 0 1 * * ?")//cron表达式每天凌晨一点
//    @Scheduled(fixedDelay = 1000 * 60 * 10)
    public void synchronization() throws IOException, ParseException {
        loanDiscardDetailsService.SyncStart();
//        System.out.println("执行了");
    }

    @SneakyThrows
    @Override
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        System.out.println("开始同步借款接口(废弃&付款)");
        synchronized (this) {
            loanDiscardDetailsService.SyncStart();
        }
        System.out.println("完成同步借款接口(废弃&付款)");
    }
}
