package org.jeecg.modules.iost.API.TimedTask;

import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.modules.iost.API.service.IQueryLoanDetailsService;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.text.ParseException;

@Slf4j
@Component
@EnableScheduling
public class QueryLoanTimed implements Job {
    @Autowired
    private IQueryLoanDetailsService queryLoanDetailsService;

    /**
     * 测试定时
     */
//     @Scheduled(cron = "0 0 1 * * ?")//cron表达式每天凌晨一点
//    @Scheduled(fixedDelay = 1000 * 60 * 10)
    public void synchronization() throws IOException, ParseException {
        queryLoanDetailsService.synchronization(null);
        System.out.println("执行了");
    }

    @SneakyThrows
    @Override
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        System.out.println("开始获取今日审批借款工单信息");
        synchronized (this) {
            try {
                queryLoanDetailsService.synchronization(null);
            } catch (Exception e) {
                Thread.sleep(1000 * 60 * 10);
                queryLoanDetailsService.synchronization(null);
            }
        }
        System.out.println("结束获取今日审批借款工单信息");
    }
}
