package org.jeecg.modules.iost.API.controller;

import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.jeecg.modules.iost.API.Dao.testDao;
import org.jeecg.modules.iost.API.ExternalInterface.LoanInterfaceApi;
import org.jeecg.modules.iost.API.entity.LQKJ_t_IMSSyncDetails;
import org.jeecg.modules.iost.API.service.ILQKJ_t_IMSSyncDetailsService;
import org.jeecg.modules.iost.API.service.impl.LQKJ_t_IMSSyncDetailsServiceImpl;
import org.jeecg.modules.iost.API.vo.LQKJ_t_IMSSync;
import org.jeecg.modules.iost.API.vo.OaRequest;
import org.jeecg.modules.iost.API.webapi.LQKJ_t_IMSSyncDetailsWebapi;
import org.jeecg.modules.iost.API.webapi.LoanInterfaceWebapi;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.alibaba.fastjson.JSON;
import redis.clients.jedis.Jedis;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

@Api(tags = "")
@RestController
@RequestMapping("/API/OA")
@Slf4j
@Scope(value="singleton")
public class ApiTestContrller {
    @Autowired
    private LQKJ_t_IMSSyncDetailsWebapi webapi;
    @Autowired
    LoanInterfaceApi loanInterfaceApi;
    @Autowired
    LoanInterfaceWebapi loanInterfaceWebapi;
    @Autowired
    private ILQKJ_t_IMSSyncDetailsService t_imsSyncDetailsService;

//    public static void main(String[] args) {
//
//        //连接本地的 Redis 服务
//        Jedis jedis = new Jedis("localhost");
//        // 如果 Redis 服务设置了密码，需要下面这行，没有就不需要
//        // jedis.auth("123456");
//        System.out.println("连接成功");
////        jedis.set()
//        //查看服务是否运行
//        System.out.println("服务正在运行: "+jedis.ping());
//    }

//    @GetMapping("/")
//    public  Object adc() throws InterruptedException {
//        codeCache.init();
//        System.out.println(testDao.K3CloudURL);
//        return testDao.K3CloudURL;
//    }


//    @GetMapping("/test/1012")
    public Object dtr(@RequestParam(required = false) Map object) {
        System.out.println(object);
        QueryWrapper<LQKJ_t_IMSSyncDetails> queryWrapper = new QueryWrapper<LQKJ_t_IMSSyncDetails>();
        queryWrapper.eq("F_LQKJ_Syncbill", "ER_ExpReimbursement_Travel").and(wq -> wq.eq("F_LQKJ_SyncCheck", 0));//get本地记录筛选收费单，未同步
        ILQKJ_t_IMSSyncDetailsService ilqkj_t_imsSyncDetailsService = new LQKJ_t_IMSSyncDetailsServiceImpl();
        List<LQKJ_t_IMSSyncDetails> lqkj_t_imsSyncDetails = t_imsSyncDetailsService.getBaseMapper().selectList(queryWrapper);
        List<LQKJ_t_IMSSyncDetails> SyncDetails = new ArrayList<>();
        Map<String, String> fidMap = new IdentityHashMap<String, String>();
        for (LQKJ_t_IMSSyncDetails lqkj_t_imsSyncDetail : lqkj_t_imsSyncDetails) {//遍历同步
            String f_lqkj_syncDataId = lqkj_t_imsSyncDetail.getFLqkjSyncdataid();//获取未同步收费单的fid
//            SyncDetails.add(lqkj_t_imsSyncDetail.setF_lqkj_synccheck(1));//设置同步状态为已同步
            fidMap.put(new String("FID"), "'" + f_lqkj_syncDataId + "'");//允许同key的map做in语句
        }
        return lqkj_t_imsSyncDetails.toString();
    }

    public Object tes() throws IOException, ParseException {
        Map returnResult = new HashMap();
        Map params = new LinkedHashMap() {{
            put("method", "queryConcludeData");
            put("type", "ER_ExpenseRequest");
//            put("date", beforeDayByNowDay());
        }};
        String responsejson = "";
        responsejson = loanInterfaceApi.getSelect(params);//获取借款
        List list = checkBillNo(responsejson);

        return list;

    }

    private List checkBillNo(String responsejson) {
        Map list = JSON.parseObject(responsejson, Map.class,Feature.OrderedField);
        Object result = JSONObject.fromObject(responsejson).get("result");
        List resultList = (List) result;
        Map<String, String> fBilNoMap = new IdentityHashMap<String, String>();
        List<Map> stringList = null;
        List returnList = resultList;
        for (int i = 0; i < resultList.size(); i++) {
            Object o = resultList.get(i);
            JSONObject re = JSONObject.fromObject(o);
            Object fBillNo = re.get("FBillNo");
            if (null != fBillNo)
                fBilNoMap.put(new String("FBillNo "), "'" + fBillNo + "'");//允许同key的map做in语句
        }

        if (null != fBilNoMap && 0 < fBilNoMap.size())
            stringList = loanInterfaceWebapi.selectFBillNo(fBilNoMap);

        if (null != stringList && 0 < stringList.size()) {
            List returns = new ArrayList();
            for (int i = 0; i < resultList.size(); i++) {
                Object o = resultList.get(i);
                JSONObject re = JSONObject.fromObject(o);

                Object fBillNo = re.get("FBillNo");
                for (int i1 = 0; i1 < stringList.size(); i1++) {
                    String fBillNo1 = stringList.get(i1).get("FBillNo").toString();
                    if (fBillNo.equals(fBillNo1)) {
                        System.out.println("break");
                        break;
                    }
                    System.out.println("add");
                    returns.add(o);
                }
            }
            System.out.println("returnList");
            returnList = returns;
        }
        return returnList;
    }

    public String beforeDayByNowDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.DATE, -1); //得到前一天
        String format = new SimpleDateFormat("yyyy-MM-dd").format(calendar.getTime());
        return format;
    }
}
