package org.jeecg.modules.iost.API.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.iost.API.entity.QueryLoanDetails;
import org.jeecg.modules.iost.API.entity.kingdeejournal.KingdeeSaveJournal;
import org.jeecg.modules.iost.API.service.kingdeejournal.IKingdeeSaveJournalService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

@Api(tags = "保存到金蝶信息-日志")
@RestController
@RequestMapping("/API/kingdeeSaveJournal")
@Slf4j
public class KingdeeSaveJournalController {
    @Autowired
    private IKingdeeSaveJournalService kingdeeSaveJournalService;
    /**
     * 分页列表查询
     *
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    @AutoLog(value = "金蝶保存信息日志接口-分页列表查询")
    @ApiOperation(value = "金蝶保存信息日志接口-分页列表查询", notes = "金蝶保存信息日志接口-分页列表查询")
    @GetMapping(value = "list")
    public Result<?> queryPageList(KingdeeSaveJournal kingdeeSaveJournal,
                                   @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                   @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                   HttpServletRequest req) {

        QueryWrapper<KingdeeSaveJournal> queryWrapper = QueryGenerator.initQueryWrapper(kingdeeSaveJournal, req.getParameterMap());
        Page<KingdeeSaveJournal> page = new Page<KingdeeSaveJournal>(pageNo, pageSize);
        IPage<KingdeeSaveJournal> pageList = kingdeeSaveJournalService.page(page, queryWrapper);
        return Result.OK(pageList);
    }

}
