package org.jeecg.modules.iost.API.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.iost.API.entity.LQKJ_t_IMSSyncDetails;
import org.jeecg.modules.iost.API.entity.QueryLoanDetails;
import org.jeecg.modules.iost.API.service.ILQKJ_t_IMSSyncDetailsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

@Api(tags = "查询同步记录信息-明细")
@RestController
@RequestMapping("/API/syncDetails")
@Slf4j
public class LQKJ_t_IMSSyncDetailsController {
    @Autowired
    private ILQKJ_t_IMSSyncDetailsService syncDetailsService;
    /**
     * 分页列表查询
     *
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    @AutoLog(value = "查询同步记录明细接口-分页列表查询")
    @ApiOperation(value = "查询同步记录明细接口-分页列表查询", notes = "查询同步记录明细接口-分页列表查询")
    @GetMapping(value = "list")
    public Result<?> queryPageList(LQKJ_t_IMSSyncDetails syncDetails,
                                   @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                   @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                   HttpServletRequest req) {

        QueryWrapper<LQKJ_t_IMSSyncDetails> queryWrapper = QueryGenerator.initQueryWrapper(syncDetails, req.getParameterMap());
        Page<LQKJ_t_IMSSyncDetails> page = new Page<LQKJ_t_IMSSyncDetails>(pageNo, pageSize);
        IPage<LQKJ_t_IMSSyncDetails> pageList = syncDetailsService.page(page, queryWrapper);
        return Result.OK(pageList);
    }
}
