package org.jeecg.modules.iost.API.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.modules.iost.API.service.IQueryBusinessTripDetailsService;
import org.jeecg.modules.iost.API.service.IQueryLoanDetailsService;
import org.jeecg.modules.iost.API.service.IQueryOtherDetailsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

@Api(tags = "业务手动同步")
@RestController
@RequestMapping("/API/manual")
@Slf4j
public class ManualController {
    @Autowired
    private IQueryLoanDetailsService queryLoanDetailsService;
    @Autowired
    private IQueryBusinessTripDetailsService queryBusinessTripDetailsService;
    @Autowired
    private IQueryOtherDetailsService queryOtherDetailsService;
    @AutoLog(value = "查询借款接口")
    @ApiOperation(value = "查询借款接口", notes = "查询借款接口")
    @GetMapping("/queryLoan")
    public Map QueryLoan(@RequestParam Map map){
        Map manual = queryLoanDetailsService.manual(map);
        return manual;
    }
    @AutoLog(value = "查询差旅接口")
    @ApiOperation(value = "查询差旅接口", notes = "查询差旅接口")
    @GetMapping("/queryBusinessTrip")
    public Map QueryBusinessTrip(@RequestParam Map map){
        Map manual = queryBusinessTripDetailsService.manual(map);
        return manual;
    }
    @AutoLog(value = "查询其他接口")
    @ApiOperation(value = "查询其他接口", notes = "查询其他接口")
    @GetMapping("/queryOther")
    public Map QueryOther(@RequestParam Map map){
        Map manual = queryOtherDetailsService.manual(map);
        return manual;
    }
}
