package org.jeecg.modules.iost.API.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.iost.API.entity.QueryLoanDetails;
import org.jeecg.modules.iost.API.entity.oajournal.OaSelectJournal;
import org.jeecg.modules.iost.API.service.oajournal.IOaSelectJournalService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

@Api(tags = "oa查询信息-日志")
@RestController
@RequestMapping("/API/oaSelectJournal")
@Slf4j
public class OaSelectJournalController {
    @Autowired
    private IOaSelectJournalService oaSelectJournalService;
    /**
     * 分页列表查询
     *
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    @AutoLog(value = "查询oa日志接口-分页列表查询")
    @ApiOperation(value = "查询oa日志接口-分页列表查询", notes = "查询oa日志信息-分页列表查询")
    @GetMapping(value = "list")
    public Result<?> queryPageList(OaSelectJournal oaSelectJournal,
                                   @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                   @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                   HttpServletRequest req) {

        QueryWrapper<OaSelectJournal> queryWrapper = QueryGenerator.initQueryWrapper(oaSelectJournal, req.getParameterMap());
        Page<OaSelectJournal> page = new Page<OaSelectJournal>(pageNo, pageSize);
        IPage<OaSelectJournal> pageList = oaSelectJournalService.page(page, queryWrapper);
        return Result.OK(pageList);
    }
}
