package org.jeecg.modules.iost.API.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.iost.API.entity.kingdeejournal.KingdeeSelectJournal;
import org.jeecg.modules.iost.API.entity.oajournal.OaUpdateJournal;
import org.jeecg.modules.iost.API.service.oajournal.IOaUpdateJournalService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

@Api(tags = "更新oa信息-日志")
@RestController
@RequestMapping("/API/oaUpdateJournal")
@Slf4j
public class OaUpdateJournalController {
    @Autowired
    private IOaUpdateJournalService oaUpdateJournalService;

    /**
     * 分页列表查询
     *
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    @AutoLog(value = "更新oa日志接口-分页列表查询")
    @ApiOperation(value = "更新oa日志接口-分页列表查询", notes = "更新oa日志接口-分页列表查询")
    @GetMapping(value = "list")
    public Result<?> queryPageList(OaUpdateJournal oaUpdateJournal,
                                   @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                   @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                   HttpServletRequest req) {

        QueryWrapper<OaUpdateJournal> queryWrapper = QueryGenerator.initQueryWrapper(oaUpdateJournal, req.getParameterMap());
        Page<OaUpdateJournal> page = new Page<OaUpdateJournal>(pageNo, pageSize);
        IPage<OaUpdateJournal> pageList = oaUpdateJournalService.page(page, queryWrapper);
        return Result.OK(pageList);
    }


}
