package org.jeecg.modules.iost.API.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.io.Serializable;
import java.util.Date;

@Data
@TableName("LQKJ_t_IMSSync_Details")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "对象", description = "Ims同步记录")
public class LQKJ_t_IMSSyncDetails implements Serializable {

    private static final long serialVersionUID = 1L;
    /**
     * 实体主键：FID
     * 同步记录数据内码：F_LQKJ_SyncDataId
     * 同步记录表单：F_LQKJ_Syncbill
     * 同步日期：F_LQKJ_SyndDatetime
     * 创建人：FCreatorId
     * 修改人：FModifierId
     * 创建日期：FCreateDate
     * 修改日期：FModifyDate
     * 同步：F_LQKJ_SyncCheck
     */
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String Fid;//实体主键

//    @ApiModelProperty(value = "同步记录数据内码")
//    @Column(name = "f_lqkj_syncdataid")
//    private String F_lqkj_syncdataid;//F_LQKJ_SyncDataId
//    @ApiModelProperty(value = "同步记录表单")
//    @Column(name = "f_lqkj_syncbill")
//    private String F_lqkj_syncbill;//F_LQKJ_Syncbill
//    @ApiModelProperty(value = "同步")
//    @Column(name = "f_lqkj_synccheck")
//    private Integer F_lqkj_synccheck;//F_LQKJ_SyncCheck
    @ApiModelProperty(value = "同步记录数据内码")
    private String fLqkjSyncdataid;//F_LQKJ_SyncDataId
    @ApiModelProperty(value = "同步记录表单")
    private String fLqkjSyncbill;//F_LQKJ_Syncbill
    @ApiModelProperty(value = "同步")
    private Integer fLqkjSynccheck;//F_LQKJ_SyncCheck
    /**
     * 创建日期
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private Date createtime;
}
