package org.jeecg.modules.iost.API.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 参数配置表
 * @Author: jeecg-boot
 * @Date:   2021-10-25
 * @Version: V1.0
 */
@Data
//@TableName("oa_setting")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="oa_setting对象", description="参数配置表")
public class OaSetting implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String id;
	/**指定地址*/
	@Excel(name = "指定地址", width = 15)
    @ApiModelProperty(value = "指定地址")
    private String k3cloudurl;
	/**dbid*/
	@Excel(name = "dbid", width = 15)
    @ApiModelProperty(value = "dbid")
    private String dbid;
	/**登录用户*/
	@Excel(name = "登录用户", width = 15)
    @ApiModelProperty(value = "登录用户")
    private String uid;
	/**登录密码*/
	@Excel(name = "登录密码", width = 15)
    @ApiModelProperty(value = "登录密码")
    private String pwd;
	/**lang*/
	@Excel(name = "lang", width = 15)
    @ApiModelProperty(value = "lang")
    private Integer lang;
}
