package org.jeecg.modules.iost.API.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description: 查询借款信息明细
 * @Author: jeecg-boot
 * @Date: 2021-07-09
 * @Version: V1.0
 */
@Data
@TableName("query_loan_details")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "query_loan_details对象", description = "查询借款信息-明细")
public class QueryLoanDetails implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String id;
    /**同步到金蝶后金蝶返回的实体主键
     * 实体主键
     */
    private String fid;
    /**同步到金蝶后金蝶返回的单据编号
     *单据编号
     */
    private String fnumber;

}
