package org.jeecg.modules.iost.API.entity.kingdeejournal;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;

@Data
@TableName("kingdee_select_journal")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "kingdee_select_journal对象", description = "查询金蝶-日志")
public class KingdeeSelectJournal implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String id;
    // 传入的业务
    private String businessName;
    /**
     * 业务编号
     **/
    private Integer businessNo;
    //传入金蝶信息
    private String request;
    //金蝶响应信息
    private String response;
    /**
     * 创建日期
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private java.util.Date createtime;

    /**
     * 数据同步:失败:0,成功:1
     */
    private Integer synchronization;

    /**
     * 是否已成功:失败:0,成功:1
     */
    private Integer successagain;

}
