package org.jeecg.modules.iost.API.entity.oajournal;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description: 传入OA-日志，用作更新
 * @Author: jeecg-boot
 * @Date:   2021-09-24
 * @Version: V1.0
 */
@Data
@TableName("oa_update_journal")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="对象", description="更新OA信息-日志")
public class OaUpdateJournal implements Serializable {
    private static final long serialVersionUID = 1L;
    /**主键*/
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String id;
    /**报错代码*/
    private String code;
    /**返回信息*/
    private String message;
    //传入OA数据
    private String requestjson;
    //OA响应数据
    private String result;
    /**创建日期*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private Date createtime;
    /**数据同步:失败:0,成功:1*/
    private Integer synchronization;
    /**
     * 是否已成功:失败:0,成功:1
     */
    private Integer successagain;
    /**业务编号**/
    private Integer businessNo;
    // 传入的业务
    private String businessName;
}
