package org.jeecg.modules.iost.API.service.impl;


import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.jeecg.modules.iost.API.Util.JsonUtil;
import org.jeecg.modules.iost.API.entity.LQKJ_t_IMSSyncDetails;
import org.jeecg.modules.iost.API.mapper.LQKJ_t_IMSSyncDetailsMapper;
import org.jeecg.modules.iost.API.service.ILQKJ_t_IMSSyncDetailsService;
import org.jeecg.modules.iost.API.service.ILoanDiscardDetailsService;
import org.jeecg.modules.iost.API.vo.LQKJ_t_IMSSync;
import org.jeecg.modules.iost.API.webapi.LQKJ_t_IMSSyncDetailsWebapi;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.GetMapping;

import java.io.IOException;
import java.text.ParseException;
import java.util.*;

@Service
public class LQKJ_t_IMSSyncDetailsServiceImpl extends ServiceImpl<LQKJ_t_IMSSyncDetailsMapper, LQKJ_t_IMSSyncDetails> implements ILQKJ_t_IMSSyncDetailsService {

    @Autowired
    private LQKJ_t_IMSSyncDetailsWebapi webapi;

    //限制一百条
    synchronized public Object synchronization() {
        Map<String, List<Map>> synchronization = webapi.synchronization(new HashMap() {{
            put("F_LQKJ_SyncCheck = ", 0);
        }});
        List<Map> objects = new ArrayList();
        if (synchronization != null)
            for (String key : synchronization.keySet()) {
                List<Map> lists = synchronization.get(key);
                List<LQKJ_t_IMSSyncDetails> SyncDetails = new ArrayList<>();
                Map<String, String> fidMap = new IdentityHashMap<String, String>();
                for (Map o : lists) {
                    if (o.containsKey("F_LQKJ_Syncbill"))//判断是否有字段
                        if ("ER_ExpenseRequest".equals(o.get("F_LQKJ_Syncbill"))) {//判断收费单
                            LQKJ_t_IMSSyncDetails lqkj_t_imsSync = JSON.parseObject(JSON.toJSONString(o), LQKJ_t_IMSSyncDetails.class).setCreatetime(new Date());
                            SyncDetails.add(lqkj_t_imsSync);//收费单保存到本地同步记录
                            fidMap.put(new String("FID"), "'" + o.get("FID") + "'");//修改同步状态拼接 in语句
                            objects.add(new LinkedHashMap() {{
                                put("FID", o.get("FID"));
                                put("F_LQKJ_SyncCheck", "1");
                            }});
                            continue;
                        }
                    if ("ER_ExpReimbursement_Travel".equals(o.get("F_LQKJ_Syncbill"))) {//判断差旅费用报销单
                        LQKJ_t_IMSSyncDetails lqkj_t_imsSync = JSON.parseObject(JSON.toJSONString(o), LQKJ_t_IMSSyncDetails.class).setCreatetime(new Date());
                        SyncDetails.add(lqkj_t_imsSync);//差旅费用报销单保存到本地同步记录
                        fidMap.put(new String("FID"), "'" + o.get("FID") + "'");//修改同步状态拼接 in语句
                        objects.add(new LinkedHashMap() {{
                            put("FID", o.get("FID"));
                            put("F_LQKJ_SyncCheck", "1");
                        }});
                        continue;
                    }
                    if ("ER_ExpReimbursement".equals(o.get("F_LQKJ_Syncbill"))) {//判断费用报销单
                        LQKJ_t_IMSSyncDetails lqkj_t_imsSync = JSON.parseObject(JSON.toJSONString(o), LQKJ_t_IMSSyncDetails.class).setCreatetime(new Date());
                        SyncDetails.add(lqkj_t_imsSync);//费用报销单保存到本地同步记录
                        fidMap.put(new String("FID"), "'" + o.get("FID") + "'");//修改同步状态拼接 in语句
                        objects.add(new LinkedHashMap() {{
                            put("FID", o.get("FID"));
                            put("F_LQKJ_SyncCheck", "1");
                        }});;
                        continue;
                    }

                }
                if (0 < SyncDetails.size()) this.saveBatch(SyncDetails);//数据保存到本地用作同步
//                if (0 < fidMap.size()) webapi.updateMap(fidMap);//修改同步状态
                if (0 < objects.size()) webapi.updateByJson(JsonUtil.Listjson(objects));
            }
        return synchronization;
    }
}
