package org.jeecg.modules.iost.API.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.jeecg.modules.iost.API.ExternalInterface.OtherReimbursementInterfaceApi;
import org.jeecg.modules.iost.API.Util.OAUtil;
import org.jeecg.modules.iost.API.entity.OtherReimbursementDetails;
import org.jeecg.modules.iost.API.entity.LQKJ_t_IMSSyncDetails;
import org.jeecg.modules.iost.API.mapper.OtherReimbursementDetailsMapper;
import org.jeecg.modules.iost.API.service.IOtherReimbursementDetailsService;
import org.jeecg.modules.iost.API.service.ILQKJ_t_IMSSyncDetailsService;
import org.jeecg.modules.iost.API.service.kingdeejournal.IKingdeeSelectJournalService;
import org.jeecg.modules.iost.API.service.oajournal.IOaUpdateJournalService;
import org.jeecg.modules.iost.API.webapi.OtherReimbursementInterfaceWebapi;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.text.ParseException;
import java.util.*;

@Service
public class OtherReimbursementDetailsServiceImpl extends ServiceImpl<OtherReimbursementDetailsMapper, OtherReimbursementDetails> implements IOtherReimbursementDetailsService {
    @Autowired
    private OtherReimbursementInterfaceWebapi otherReimbursementInterfaceWebapi;
    @Autowired
    private OtherReimbursementInterfaceApi otherReimbursementInterfaceApi;
    @Autowired
    private IKingdeeSelectJournalService kingdeeSelectJournalService;
    @Autowired
    private IOaUpdateJournalService oaUpdateJournalService;
    @Autowired
    private ILQKJ_t_IMSSyncDetailsService t_imsSyncDetailsService;

    @Override
    public synchronized void SyncStart() throws IOException, ParseException {
        QueryWrapper<LQKJ_t_IMSSyncDetails> queryWrapper = new QueryWrapper<LQKJ_t_IMSSyncDetails>();
        queryWrapper.eq("F_LQKJ_Syncbill", "ER_ExpReimbursement").and(wq -> wq.eq("F_LQKJ_SyncCheck", 0));//get本地记录筛选收费单，未同步
        List<LQKJ_t_IMSSyncDetails> lqkj_t_imsSyncDetails = t_imsSyncDetailsService.getBaseMapper().selectList(queryWrapper);
        List<LQKJ_t_IMSSyncDetails> SyncDetails = new ArrayList<>();
        Map<String, String> fidMap = new IdentityHashMap<String, String>();
        for (LQKJ_t_IMSSyncDetails lqkj_t_imsSyncDetail : lqkj_t_imsSyncDetails) {//遍历同步
            String f_lqkj_syncDataId = lqkj_t_imsSyncDetail.getFLqkjSyncdataid();//获取未同步收费单的fid
            SyncDetails.add(lqkj_t_imsSyncDetail.setFLqkjSynccheck(1));//设置同步状态为已同步
            fidMap.put(new String("FID"), "'" + f_lqkj_syncDataId + "'");//允许同key的map做in语句
        }

        t_imsSyncDetailsService.updateBatchById(SyncDetails);//更新收费单同步状态
        Object synchronization = synchronization(fidMap);
    }

    @Override
    public Object synchronization(Map object) throws IOException, ParseException {
        Map<String, List<Map>> synchronization = null;
        if (0 < object.size()) {
            synchronization = otherReimbursementInterfaceWebapi.synchronization(object);
        }
        if (null != synchronization)
            for (String key : synchronization.keySet()) {
                List<Map> lists = synchronization.get(key);
                if (null != lists)
                    for (Map list : lists) {
                        if (list.get("FCancelStatus").toString().equals("B")) {//判断废弃状态 -已废弃
                            Map params = new LinkedHashMap() {{
                                put("method", "discardWorknumber");
                                put("worknumber", list.get("FBillNo").toString());
                                put("status", "废弃");
                                put("type","ER_ExpReimbursement");//费用报销
                            }};
                            String select = otherReimbursementInterfaceApi.update(params);
                            oaUpdateJournalService.setOaUpdateJournal(OAUtil.MapToString(params), select, 11);
                            continue;
                        }
                        if (list.get("FDocumentStatus").toString().equals("C")) {//判断付款状态 -已付款
                            Map params = new LinkedHashMap() {{
                                put("method", "paymentStatus");
                                put("worknumber", list.get("FBillNo").toString());
                                put("status", "已付款");
                                put("type","ER_ExpReimbursement");//费用报销
                            }};
                            String select = otherReimbursementInterfaceApi.update(params);
                            oaUpdateJournalService.setOaUpdateJournal(OAUtil.MapToString(params), select, 12);
                        }
                    }
                String kingdeeRequest = key;
                Integer BusinessNo = 10;
                List<Map> kingdeeResponse = lists;
                kingdeeSelectJournalService.setKingdeeSelect(kingdeeRequest, kingdeeResponse, BusinessNo);
                continue;
            }
        return synchronization;
    }

    @Override
    public Boolean manual(Map<String, Object> map, String ReturnProcessId) throws ParseException {
        return null;
    }
}
