package org.jeecg.modules.iost.API.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import net.sf.json.JSONObject;
import org.jeecg.modules.iost.API.ExternalInterface.BusinessTripInterfaceApi;
import org.jeecg.modules.iost.API.Util.JsonUtil;
import org.jeecg.modules.iost.API.Util.OAUtil;
import org.jeecg.modules.iost.API.entity.QueryBusinessTripDetails;
import org.jeecg.modules.iost.API.mapper.QueryBusinessTripDetailsMapper;
import org.jeecg.modules.iost.API.service.IQueryBusinessTripDetailsService;
import org.jeecg.modules.iost.API.service.kingdeejournal.IKingdeeSaveJournalService;
import org.jeecg.modules.iost.API.service.oajournal.IOaSelectJournalService;
import org.jeecg.modules.iost.API.webapi.BusinessTripInterfaceWebapi;
import org.jeecg.modules.iost.API.webapi.SALorderWebapi;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

@Service
public class QueryBusinessTripDetailsServiceImpl extends ServiceImpl<QueryBusinessTripDetailsMapper, QueryBusinessTripDetails> implements IQueryBusinessTripDetailsService {
    @Autowired
    private BusinessTripInterfaceApi businessTripInterfaceApi;
    @Autowired
    private BusinessTripInterfaceWebapi businessTripInterfaceWebapi;
    @Autowired
    private IOaSelectJournalService oaSelectJournalService;
    @Autowired
    private IKingdeeSaveJournalService KingdeeSaveJournalService;
    @Autowired
    private SALorderWebapi salwebapi;

    private int BusinessNo = 5;

    @Override
    synchronized public Map synchronization(Map object) throws IOException, ParseException {
        Map returnResult = new HashMap();
        returnResult.put("message", "同步完成");
        returnResult.put("result", "流程结束");


        Map params = new LinkedHashMap() {{
            put("method", "queryConcludeData");
            put("type", "ER_ExpReimbursement_Travel");
            put("date", beforeDayByNowDay());
        }};
        try {
            if (null != object && null != object.get("date")) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                String date = sdf.format(sdf.parse(object.get("date").toString()));
                params = new LinkedHashMap() {{
                    put("method", "queryConcludeData");
                    put("type", "ER_ExpReimbursement_Travel");
                    put("date", date);
                }};
            }
        } catch (Exception e) {
            returnResult.put("message", "手动同步失败");
            returnResult.put("result", "参数无法解析");
            return returnResult;
        }


        String responsejson = "";
        String requestJson = JsonUtil.Mapjson(params);
        boolean faceApiCatch = true;
        boolean webApiCatch = true;
        String add = "";

        try {
            responsejson = businessTripInterfaceApi.getSelect(params);//获取借款

        } catch (Exception e) {
            faceApiCatch = false;
            responsejson = e.toString();
            oaSelectJournalService.setOaSelectJournalError(requestJson, responsejson, BusinessNo);
            returnResult.put("message", "请求数据报错");
            returnResult.put("result", "调用接口异常"+responsejson);
            return returnResult;
        }
        if (faceApiCatch) oaSelectJournalService.setOaSelectJournal(requestJson, responsejson, BusinessNo);

        JSONObject jsonObject = JSONObject.fromObject(responsejson);
        Object result = jsonObject.get("result");
        String s = result.toString();


        try {
            add = businessTripInterfaceWebapi.batchAdd(OAUtil.filter(s,salwebapi));
        } catch (Exception e) {
            webApiCatch = false;
            e.printStackTrace();
            add = e.toString();
            KingdeeSaveJournalService.setKingdeeSaveError(s, add, BusinessNo);
            returnResult.put("message", "保存数据报错");
            returnResult.put("result", add);
        }
        if (webApiCatch) KingdeeSaveJournalService.setKingdeeSave(s, add, BusinessNo);
        JSONObject Result = JSONObject.fromObject(add);//
        JSONObject ResponseStatus = JSONObject.fromObject(JSONObject.fromObject(Result.get("Result")).get("ResponseStatus"));
        if (null == add || null == (Boolean) ResponseStatus.get("IsSuccess") || !(Boolean) ResponseStatus.get("IsSuccess")) {//判断请求是否错误
            returnResult.put("message", "流程完成");
            returnResult.put("result", "数据未同步");
            List successEntitys = (List) ResponseStatus.get("SuccessEntitys");
            if (null != successEntitys && 0 < successEntitys.size()) {
                returnResult.put("result", "部分数据未同步");
            }
        }
        return returnResult;
    }

    /**
     * 获取当前日期的前一天
     * 需要返回的日期格式，例如：yyyy-MM-dd HH:mm:ss
     *
     * @return 前一天日期字符串
     */
    public String beforeDayByNowDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.DATE, -1); //得到前一天
        String format = new SimpleDateFormat("yyyy-MM-dd").format(calendar.getTime());
        return format;
    }

    @Override
    public Map manual(Map map) {
        Map synchronization = null;
        try {
            synchronization = this.synchronization(map);
        } catch (IOException e) {
            e.printStackTrace();
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return synchronization;
    }


    public String filterF_QPOV_Base(String s, Map returnResult) {
        List<LinkedHashMap> list = JSON.parseObject(s, List.class, Feature.OrderedField);
        List<LinkedHashMap> returnResults = new ArrayList<LinkedHashMap>();
        Map<String, String> fNumber = new IdentityHashMap<String, String>();
        for (Map map : list) {
            if (map.containsKey("F_QPOV_Base")) {
                Object f_qpov_base = map.get("F_QPOV_Base");
                fNumber.put(new String("FNumber"), "'" + f_qpov_base + "'");
            }
        }
        List<List<Object>> lists = salwebapi.selectIn(fNumber);

        for (LinkedHashMap map : list) {
            boolean on = false;
            if (map.containsKey("F_QPOV_Base")) {
                String f_qpov_base = map.get("F_QPOV_Base").toString();
                for (int i = 0; i < lists.size(); i++) {
                    String o = lists.get(i).get(0).toString();
                    if (f_qpov_base.equals(o)) {
                        on = true;
                        break;
                    }
                }
                if (!on) {
                    returnResult.put(map, "字段F_QPOV_Base错误数据");
                }
            } else {
                returnResult.put(map, "字段F_QPOV_Base不存在");
            }
            if (on) returnResults.add(map);

        }


        return null;
    }
}
