package org.jeecg.modules.iost.API.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import net.sf.json.JSONObject;
import org.jeecg.modules.iost.API.ExternalInterface.OtherReimbursementInterfaceApi;
import org.jeecg.modules.iost.API.Util.JsonUtil;
import org.jeecg.modules.iost.API.Util.OAUtil;
import org.jeecg.modules.iost.API.entity.QueryOtherDetails;
import org.jeecg.modules.iost.API.mapper.QueryOtherDetailsMapper;
import org.jeecg.modules.iost.API.service.IQueryOtherDetailsService;
import org.jeecg.modules.iost.API.service.kingdeejournal.IKingdeeSaveJournalService;
import org.jeecg.modules.iost.API.service.oajournal.IOaSelectJournalService;
import org.jeecg.modules.iost.API.webapi.OtherReimbursementInterfaceWebapi;
import org.jeecg.modules.iost.API.webapi.SALorderWebapi;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

@Service
public class QueryOtherDetailsServiceImpl extends ServiceImpl<QueryOtherDetailsMapper, QueryOtherDetails> implements IQueryOtherDetailsService {
    @Autowired
    private OtherReimbursementInterfaceApi interfaceApi;
    @Autowired
    private OtherReimbursementInterfaceWebapi webapi;
    @Autowired
    private IOaSelectJournalService oaSelectJournalService;
    @Autowired
    private IKingdeeSaveJournalService KingdeeSaveJournalService;
    @Autowired
    private SALorderWebapi salwebapi;
    private int BusinessNo = 9;

    @Override
    synchronized public Map synchronization(Map object) throws IOException, ParseException {
        Map returnResult = new HashMap();
        returnResult.put("message", "同步完成");
        returnResult.put("result", "流程结束");
        Map params = new LinkedHashMap() {{
            put("method", "queryConcludeData");
            put("type", "ER_ExpReimbursement");
            put("date", beforeDayByNowDay());
        }};
        try {
            if (null != object && null != object.get("date")) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                String date = sdf.format(sdf.parse(object.get("date").toString()));
                params = new LinkedHashMap() {{
                    put("method", "queryConcludeData");
                    put("type", "ER_ExpReimbursement");
                    put("date", date);
                }};
            }
        } catch (Exception e) {
            returnResult.put("message", "手动同步失败");
            returnResult.put("result", "参数无法解析");
            return returnResult;
        }


        String responsejson = "";
        String requestJson = JsonUtil.Mapjson(params);
        boolean faceApiCatch = true;
        boolean webApiCatch = true;
        String add = "";

        try {
            responsejson = interfaceApi.getSelect(params);//获取借款
        } catch (Exception e) {
            faceApiCatch = false;
            responsejson = e.toString();
            oaSelectJournalService.setOaSelectJournalError(requestJson, responsejson, BusinessNo);
            returnResult.put("message", "请求数据报错");
            returnResult.put("result", "调用接口异常"+responsejson);
            return returnResult;
        }
        if (faceApiCatch) oaSelectJournalService.setOaSelectJournal(requestJson, responsejson, BusinessNo);

        JSONObject jsonObject = JSONObject.fromObject(responsejson);
        Object result = jsonObject.get("result");
        String s = result.toString();
        try {
            add = webapi.batchAdd(OAUtil.filter(s,salwebapi));
        } catch (Exception e) {
            webApiCatch = false;
            e.printStackTrace();
            add = e.toString();
            KingdeeSaveJournalService.setKingdeeSaveError(s, add, BusinessNo);
            returnResult.put("message", "保存数据报错");
            returnResult.put("result", add);
        }
        if (webApiCatch) KingdeeSaveJournalService.setKingdeeSave(s, add, BusinessNo);
        net.sf.json.JSONObject Result = net.sf.json.JSONObject.fromObject(add);//
        net.sf.json.JSONObject ResponseStatus = net.sf.json.JSONObject.fromObject(net.sf.json.JSONObject.fromObject(Result.get("Result")).get("ResponseStatus"));
        if (null == add || null == (Boolean) ResponseStatus.get("IsSuccess") || !(Boolean) ResponseStatus.get("IsSuccess") ) {//判断请求是否错误
            returnResult.put("message", "流程完成");
            returnResult.put("result", "数据未同步");
            List successEntitys = (List) ResponseStatus.get("SuccessEntitys");
            if (null!=successEntitys&&0<successEntitys.size()) {
                returnResult.put("result", "部分数据未同步");
            }
        }
        return returnResult;
    }

    /**
     * 获取当前日期的前一天
     * 需要返回的日期格式，例如：yyyy-MM-dd HH:mm:ss
     *
     * @return 前一天日期字符串
     */
    public String beforeDayByNowDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.DATE, -1); //得到前一天
        String format = new SimpleDateFormat("yyyy-MM-dd").format(calendar.getTime());
        return format;
    }


    @Override
    public Map manual(Map map) {
        Map synchronization = null;
        try {
            synchronization = this.synchronization(map);
        } catch (IOException e) {
            e.printStackTrace();
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return synchronization;
    }
}
