package org.jeecg.modules.iost.API.service.kingdeejournal.impl;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.jeecg.modules.iost.API.Util.JsonUtil;
import org.jeecg.modules.iost.API.dto.OABusiness;
import org.jeecg.modules.iost.API.entity.kingdeejournal.KingdeeSaveJournal;
import org.jeecg.modules.iost.API.entity.kingdeejournal.KingdeeSelectJournal;
import org.jeecg.modules.iost.API.entity.oajournal.OaSelectJournal;
import org.jeecg.modules.iost.API.mapper.kingdeejournal.KingdeeSaveJournalMapper;
import org.jeecg.modules.iost.API.service.kingdeejournal.IKingdeeSaveJournalService;
import org.jeecg.modules.iost.API.vo.OaRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

@Service
@Scope("prototype")
public class KingdeeSaveJournalServiceImpl extends ServiceImpl<KingdeeSaveJournalMapper, KingdeeSaveJournal> implements IKingdeeSaveJournalService {

    @Override
    @Async
    public void setKingdeeSave(String kingdeeRequest, String kingdeeResponse, Integer BusinessNo) {
        KingdeeSaveJournal kingdeeSaveJournal = new KingdeeSaveJournal();
        kingdeeSaveJournal.setRequest(kingdeeRequest);
        kingdeeSaveJournal.setBusinessNo(BusinessNo);
        kingdeeSaveJournal.setBusinessName(OABusiness.entity.get(BusinessNo));
        kingdeeSaveJournal.setCreatetime(new Date());
        kingdeeSaveJournal.setSuccessagain(0);
        kingdeeSaveJournal.setResponse(kingdeeResponse);
        net.sf.json.JSONObject Result = net.sf.json.JSONObject.fromObject(kingdeeResponse);//
        net.sf.json.JSONObject ResponseStatus = net.sf.json.JSONObject.fromObject(net.sf.json.JSONObject.fromObject(Result.get("Result")).get("ResponseStatus"));
        if (null == kingdeeResponse || null == (Boolean) ResponseStatus.get("IsSuccess") || !(Boolean) ResponseStatus.get("IsSuccess") ) {//判断请求是否错误
            kingdeeSaveJournal.setSynchronization(0);
            List successEntitys = (List) ResponseStatus.get("SuccessEntitys");
            if (null!=successEntitys&&0<successEntitys.size()) {
                kingdeeSaveJournal.setSynchronization(2);
            }
        } else {
            kingdeeSaveJournal.setSynchronization(1);

        }
        boolean save = this.save(kingdeeSaveJournal);
    }

    @Override
    @Async
    public void setKingdeeSaveError(String requestjson, String responsejson, Integer BusinessNo) {
        KingdeeSaveJournal kingdeeSaveJournal = new KingdeeSaveJournal();
        kingdeeSaveJournal.setRequest(requestjson);
        kingdeeSaveJournal.setBusinessNo(BusinessNo);
        kingdeeSaveJournal.setBusinessName(OABusiness.entity.get(BusinessNo));
        kingdeeSaveJournal.setResponse(responsejson);
        kingdeeSaveJournal.setCreatetime(new Date());
        kingdeeSaveJournal.setResponse(responsejson);
        kingdeeSaveJournal.setSuccessagain(0);

        kingdeeSaveJournal.setSynchronization(0);

        boolean save = this.save(kingdeeSaveJournal);
    }
}
