package org.jeecg.modules.iost.API.service.kingdeejournal.impl;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import net.sf.json.JSONObject;
import org.apache.poi.ss.formula.functions.T;
import org.jeecg.modules.iost.API.Util.JsonUtil;
import org.jeecg.modules.iost.API.dto.OABusiness;
import org.jeecg.modules.iost.API.entity.kingdeejournal.KingdeeSelectJournal;
import org.jeecg.modules.iost.API.mapper.kingdeejournal.KingdeeSelectJournalMapper;
import org.jeecg.modules.iost.API.service.kingdeejournal.IKingdeeSelectJournalService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.util.Date;
import java.util.List;

@Service
@Scope("prototype")
public class KingdeeSelectJournalServiceImpl extends ServiceImpl<KingdeeSelectJournalMapper, KingdeeSelectJournal> implements IKingdeeSelectJournalService {


    @Override
    /**
     *返回null为请求失败
     * boolean为判断是否保存
     */
    @Async
    public void setKingdeeSelect(String kingdeeRequest, List kingdeeResponse, Integer BusinessNo) {
        KingdeeSelectJournal kingdeeSelectJournal = new KingdeeSelectJournal();
        kingdeeSelectJournal.setRequest(kingdeeRequest);
        kingdeeSelectJournal.setBusinessNo(BusinessNo);
        kingdeeSelectJournal.setBusinessName(OABusiness.entity.get(BusinessNo));
        kingdeeSelectJournal.setCreatetime(new Date());
        kingdeeSelectJournal.setSuccessagain(0);
        if (0 == kingdeeResponse.size()) {//判断是否保存日志
            return ;
        }
        if (null == kingdeeResponse) {
            kingdeeSelectJournal.setResponse("请求失败");
            kingdeeSelectJournal.setSynchronization(0);
        } else if (null != kingdeeResponse && 0 < kingdeeResponse.size()) {
            kingdeeSelectJournal.setResponse(JsonUtil.Listjson(kingdeeResponse));
            kingdeeSelectJournal.setSynchronization(1);
        }
        boolean save = this.save(kingdeeSelectJournal);
    }
}
