package org.jeecg.modules.iost.API.service.oajournal.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.jeecg.modules.iost.API.dto.OABusiness;
import org.jeecg.modules.iost.API.entity.oajournal.OaSelectJournal;
import org.jeecg.modules.iost.API.mapper.oajournal.OaSelectJournalMapper;
import org.jeecg.modules.iost.API.service.oajournal.IOaSelectJournalService;
import org.jeecg.modules.iost.API.vo.OaRequest;
import org.springframework.context.annotation.Scope;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.Date;
@Service
@Scope("prototype")
public class OaSelectJournalServiceImpl extends ServiceImpl<OaSelectJournalMapper,OaSelectJournal> implements IOaSelectJournalService {
    @Override
    @Async
    public void setOaSelectJournal(String requestjson, String responsejson, Integer BusinessNo) {
        OaSelectJournal oaSelectJournal = new OaSelectJournal();
        OaRequest listOaRequest =null;
        try {
            listOaRequest=JSONObject.parseObject(responsejson, OaRequest.class);
            oaSelectJournal.setCode(listOaRequest.getCode());
            oaSelectJournal.setMessage(listOaRequest.getMessage());
            oaSelectJournal.setResult(listOaRequest.getResult().toString());
            oaSelectJournal.setSynchronization(1);
        }catch (Exception e){
            e.printStackTrace();
            oaSelectJournal.setSynchronization(0);
            oaSelectJournal.setResult(responsejson);
        }finally {
            oaSelectJournal.setBusinessNo(BusinessNo);
            oaSelectJournal.setBusinessName(OABusiness.entity.get(BusinessNo));
            oaSelectJournal.setRequestjson(requestjson);
            oaSelectJournal.setCreatetime(new Date());
            oaSelectJournal.setSuccessagain(0);
            this.save(oaSelectJournal);
        }
    }

    @Async
    public void setOaSelectJournalError(String requestjson, String responsejson, Integer BusinessNo) {
        OaSelectJournal oaSelectJournal = new OaSelectJournal();
            oaSelectJournal.setSynchronization(0);
            oaSelectJournal.setResult(responsejson);
            oaSelectJournal.setBusinessNo(BusinessNo);
            oaSelectJournal.setBusinessName(OABusiness.entity.get(BusinessNo));
            oaSelectJournal.setRequestjson(requestjson);
            oaSelectJournal.setCreatetime(new Date());
            oaSelectJournal.setSuccessagain(0);
            this.save(oaSelectJournal);

    }
}
