package org.jeecg.modules.iost.API.service.oajournal.impl;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.jeecg.modules.iost.API.Util.JsonUtil;
import org.jeecg.modules.iost.API.dto.OABusiness;
import org.jeecg.modules.iost.API.entity.kingdeejournal.KingdeeSelectJournal;
import org.jeecg.modules.iost.API.entity.oajournal.OaUpdateJournal;
import org.jeecg.modules.iost.API.mapper.oajournal.OaUpdateJournalMapper;
import org.jeecg.modules.iost.API.service.oajournal.IOaUpdateJournalService;
import org.jeecg.modules.iost.API.vo.OaRequest;
import org.springframework.context.annotation.Scope;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Map;

@Service
@Scope("prototype")
public class OaUpdateJournalServiceImpl extends ServiceImpl<OaUpdateJournalMapper, OaUpdateJournal> implements IOaUpdateJournalService {
    /**
     * 返回null为请求失败
     * boolean为判断是否保存
     */
    @Override
    @Async
    public void setOaUpdateJournal(String requestjson, String responsejson, Integer BusinessNo) {
        OaUpdateJournal oaUpdateJournal = new OaUpdateJournal();
        OaRequest<String> listOaRequest =null;
        try {
            listOaRequest=JSONObject.parseObject(responsejson, OaRequest.class);
            oaUpdateJournal.setCode(listOaRequest.getCode());
            oaUpdateJournal.setMessage(listOaRequest.getMessage());
//            oaUpdateJournal.setResult(listOaRequest.getResult());
            oaUpdateJournal.setResult(responsejson);
            oaUpdateJournal.setSynchronization("成功".equals(listOaRequest.getMessage())?1:0);
        }catch (Exception e){
            oaUpdateJournal.setSynchronization(0);
        }finally {
            oaUpdateJournal.setBusinessNo(BusinessNo);
            oaUpdateJournal.setBusinessName(OABusiness.entity.get(BusinessNo));
            oaUpdateJournal.setRequestjson(requestjson);
            oaUpdateJournal.setCreatetime(new Date());
            oaUpdateJournal.setSuccessagain(0);
            this.save(oaUpdateJournal);
        }

    }


}
