package org.jeecg.modules.iost.API.webapi;

import org.jeecg.modules.iost.API.Dao.CategoryDao;
import org.jeecg.modules.iost.API.Dao.CategoryDaoSql;
import org.jeecg.modules.iost.API.webapi.Interface.web_api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
@Component
public class BusinessTripInterfaceWebapi implements web_api {

    /**
     * 操作的单据体名称
     * 费用申请单
     */
    private String sFormId = "ER_ExpReimbursement_Travel";
    private String sFormId_t = "t_ER_ExpenseReimb";

    private Map<String, String> key = new LinkedHashMap<>();
    @Autowired
    private CategoryDao categoryDao;
    @Autowired
    private CategoryDaoSql categoryDaoSql;

    BusinessTripInterfaceWebapi() {
        key.put("FID", "FID");//实体主键0
        key.put("FBillNo","FBillNo");//单据编号1 -worknumber
        key.put("FDocumentStatus","FDocumentStatus");//单据状态2
        key.put("FCancelStatus","FCancelStatus");//作废状态 3
    }

    @Override
    public String add(Object object) {
        String add = categoryDao.add(sFormId, object.toString());
        return add;
    }

    @Override
    public List<Map<String, String>> select(Map<String, String> map, String where) {
        return null;
    }

    @Override
    public String update(Object object) {
        return null;
    }

    public Map<String, List<List<Object>>> synchronization(String where) {//手动同步用
        Map<String, List<List<Object>>> stringListMap = categoryDao.selectMapWhereString(sFormId, key, where);
        return stringListMap;
    }

    public Map<String, List<Map>> synchronization(Map where) {//自动同步用
        Map<String, List<Map>> stringListMap = categoryDaoSql.selectMapIn(sFormId_t, key, where);
        return stringListMap;
    }
    public String batchAdd(Object object) {
        String add = categoryDao.batchAdd(sFormId, object.toString());
        return add;
    }
    public List<Map> selectFBillNo(Map where) {//in查询是否已有FBillNo
        List<Map> stringList = categoryDaoSql.selectIn(sFormId_t, new HashMap(){{put("FBillNo", "FBillNo");}}, where);
        return stringList;
    }
}
