package org.jeecg.modules.iost.API.webapi;

import org.jeecg.modules.iost.API.Dao.CategoryDao;
import org.jeecg.modules.iost.API.Dao.CategoryDaoSql;
import org.jeecg.modules.iost.API.webapi.Interface.web_api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Component
public class LQKJ_t_IMSSyncDetailsWebapi implements web_api {
    /**
     * 操作的单据体名称
     * ims同步记录
     */
    private String sFormId = "LQKJ_IMSSync";
    private String sFormId_t = "LQKJ_t_IMSSync";
    private Map<String, String> key = new LinkedHashMap<>();
    @Autowired
    private CategoryDao categoryDao;
    @Autowired
    private CategoryDaoSql categoryDaoSql;

    /**
     * 实体主键：FID
     * 同步记录数据内码：F_LQKJ_SyncDataId
     * 同步记录表单：F_LQKJ_Syncbill
     * 同步日期：F_LQKJ_SyndDatetime
     * 创建人：FCreatorId
     * 修改人：FModifierId
     * 创建日期：FCreateDate
     * 修改日期：FModifyDate
     * 同步：F_LQKJ_SyncCheck
     */
    public LQKJ_t_IMSSyncDetailsWebapi() {
        key.put("FID", "FID");//实体主键0
        key.put("F_LQKJ_SyncDataId", "F_LQKJ_SyncDataId");//同步记录数据内码1
        key.put("F_LQKJ_Syncbill", "F_LQKJ_Syncbill");//同步记录表单2
        key.put("F_LQKJ_SyncCheck", "F_LQKJ_SyncCheck");//同步3 否为0 ，是为1
    }

    @Override
    public String add(Object object) {
        return null;
    }

    @Override
    public List<Map<String, String>> select(Map<String, String> map, String where) throws ParseException {
        return null;
    }

    @Override
    public String update(Object object) { return null; }

    public Map<String, List<Object>> updateMap(Map where) {
        Map<String, String> set = new LinkedHashMap(){{put("F_LQKJ_SyncCheck","1");}};

        Map<String, List<Object>> map = categoryDaoSql.updateInMap(sFormId_t, set, where);
        return map;
    }
    public String updateByJson(String json) {
        String map = categoryDao.updateInMap(sFormId, json);
        return map;
    }
    public Map<String, List<List<Object>>> synchronization(String where) {//手动同步用
        Map<String, List<List<Object>>> stringListMap = categoryDao.selectMapWhereString(sFormId, key, where);
        return stringListMap;
    }

    public Map<String, List<Map>> synchronization(Map where) {//自动同步用
//        Map<String, List<List<Object>>> stringListMap = categoryDaoSql.selectInMap(sFormId_t, key, where);
        Map<String, List<Map>> stringListMap = categoryDaoSql.selectInMap(sFormId_t, key, where);
        return stringListMap;
    }
}
