package org.jeecg.modules.iost.basedata.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jeecg.modules.iost.basedata.service.IIostDeliveryRecordPageService;
import org.jeecg.modules.iost.basedata.vo.IostDeliveryRecordPage;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.jeecg.common.system.vo.LoginUser;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.iost.basedata.entity.IostDeliverstatusList;
import org.jeecg.modules.iost.basedata.entity.IostDeliverstatus;
import org.jeecg.modules.iost.basedata.vo.IostDeliverstatusPage;
import org.jeecg.modules.iost.basedata.service.IIostDeliverstatusService;
import org.jeecg.modules.iost.basedata.service.IIostDeliverstatusListService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;

 /**
 * @Description: 更新物流状态
 * @Author: jeecg-boot
 * @Date:   2020-11-16
 * @Version: V1.0
 */
@Api(tags="更新物流状态")
@RestController
@RequestMapping("/basedata/iostDeliverstatus")
@Slf4j
public class IostDeliverstatusController {
	@Autowired
	private IIostDeliverstatusService iostDeliverstatusService;
	@Autowired
	private IIostDeliverstatusListService iostDeliverstatusListService;
	@Autowired
	private IIostDeliveryRecordPageService iostDeliveryRecordPageService;
	
	/**
	 * 分页列表查询
	 *
	 * @param iostDeliverstatus
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	@AutoLog(value = "更新物流状态-分页列表查询")
	@ApiOperation(value="更新物流状态-分页列表查询", notes="更新物流状态-分页列表查询")
	@GetMapping(value = "/list")
	public Result<?> queryPageList(IostDeliverstatus iostDeliverstatus,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<IostDeliverstatus> queryWrapper = QueryGenerator.initQueryWrapper(iostDeliverstatus, req.getParameterMap());
		Page<IostDeliverstatus> page = new Page<IostDeliverstatus>(pageNo, pageSize);
		IPage<IostDeliverstatus> pageList = iostDeliverstatusService.page(page, queryWrapper);
		return Result.OK(pageList);
	}

	 /**
	 *   添加
	 *
	 * @param iostDeliverstatusPage
	 * @return
	 */
	@AutoLog(value = "更新物流状态-添加")
	@ApiOperation(value="更新物流状态-添加", notes="更新物流状态-添加")
	@PostMapping(value = "/add")
	public Result<?> add(@RequestBody IostDeliverstatusPage iostDeliverstatusPage) {
		IostDeliverstatus iostDeliverstatus = new IostDeliverstatus();
		BeanUtils.copyProperties(iostDeliverstatusPage, iostDeliverstatus);
		iostDeliverstatusService.saveMain(iostDeliverstatus, iostDeliverstatusPage.getIostDeliverstatusListList());
		return Result.OK("添加成功！");
	}
	
	/**
	 *  编辑
	 *
	 * @param iostDeliverstatusPage
	 * @return
	 */
	@AutoLog(value = "更新物流状态-编辑")
	@ApiOperation(value="更新物流状态-编辑", notes="更新物流状态-编辑")
	@PutMapping(value = "/edit")
	public Result<?> edit(@RequestBody IostDeliverstatusPage iostDeliverstatusPage) {
		IostDeliverstatus iostDeliverstatus = new IostDeliverstatus();
		BeanUtils.copyProperties(iostDeliverstatusPage, iostDeliverstatus);
		IostDeliverstatus iostDeliverstatusEntity = iostDeliverstatusService.getById(iostDeliverstatus.getId());
		if(iostDeliverstatusEntity==null) {
			return add(iostDeliverstatusPage);
		}
		iostDeliverstatusService.updateMain(iostDeliverstatus, iostDeliverstatusPage.getIostDeliverstatusListList());
		return Result.OK("编辑成功!");
	}
	
	/**
	 *   通过id删除
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "更新物流状态-通过id删除")
	@ApiOperation(value="更新物流状态-通过id删除", notes="更新物流状态-通过id删除")
	@DeleteMapping(value = "/delete")
	public Result<?> delete(@RequestParam(name="id",required=true) String id) {
		iostDeliverstatusService.delMain(id);
		return Result.OK("删除成功!");
	}
	
	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "更新物流状态-批量删除")
	@ApiOperation(value="更新物流状态-批量删除", notes="更新物流状态-批量删除")
	@DeleteMapping(value = "/deleteBatch")
	public Result<?> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.iostDeliverstatusService.delBatchMain(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功！");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "更新物流状态-通过id查询")
	@ApiOperation(value="更新物流状态-通过id查询", notes="更新物流状态-通过id查询")
	@GetMapping(value = "/queryById")
	public Result<?> queryById(@RequestParam(name="id",required=true) String id) {
		IostDeliverstatus iostDeliverstatus = iostDeliverstatusService.getById(id);
		if(iostDeliverstatus==null) {
			return Result.error("未找到对应数据");
		}
		return Result.OK(iostDeliverstatus);

	}

	 /**
	  * 查询列表
	  *
	  * @param
	  * @return
	  */
	 @AutoLog(value = "更新物流状态-查询列表")
	 @ApiOperation(value="更新物流状态-查询列表", notes="更新物流状态-查询列表")
	 @GetMapping(value = "/selectlist")
	 public Result<?> selectlist(IostDeliveryRecordPage iostDeliveryRecordPage,
								 @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								 @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								 HttpServletRequest req) {
		 List<IostDeliveryRecordPage> list = iostDeliveryRecordPageService.selectlist(iostDeliveryRecordPage,pageNo,pageSize);
		 IPage<IostDeliveryRecordPage> list2 = new Page<>();
		 list2.setRecords(list);
		 return Result.OK(list2);

	 }

	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "物流信息通过主表ID查询")
	@ApiOperation(value="物流信息主表ID查询", notes="物流信息-通主表ID查询")
	@GetMapping(value = "/queryIostDeliverstatusListByMainId")
	public Result<?> queryIostDeliverstatusListListByMainId(@RequestParam(name="id",required=true) String id) {
		List<IostDeliverstatusList> iostDeliverstatusListList = iostDeliverstatusListService.selectByMainId(id);
		return Result.OK(iostDeliverstatusListList);
	}

    /**
    * 导出excel
    *
    * @param request
    * @param iostDeliverstatus
    */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, IostDeliverstatus iostDeliverstatus) {
      // Step.1 组装查询条件查询数据
      QueryWrapper<IostDeliverstatus> queryWrapper = QueryGenerator.initQueryWrapper(iostDeliverstatus, request.getParameterMap());
      LoginUser sysUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();

      //Step.2 获取导出数据
      List<IostDeliverstatus> queryList = iostDeliverstatusService.list(queryWrapper);
      // 过滤选中数据
      String selections = request.getParameter("selections");
      List<IostDeliverstatus> iostDeliverstatusList = new ArrayList<IostDeliverstatus>();
      if(oConvertUtils.isEmpty(selections)) {
          iostDeliverstatusList = queryList;
      }else {
          List<String> selectionList = Arrays.asList(selections.split(","));
          iostDeliverstatusList = queryList.stream().filter(item -> selectionList.contains(item.getId())).collect(Collectors.toList());
      }

      // Step.3 组装pageList
      List<IostDeliverstatusPage> pageList = new ArrayList<IostDeliverstatusPage>();
      for (IostDeliverstatus main : iostDeliverstatusList) {
          IostDeliverstatusPage vo = new IostDeliverstatusPage();
          BeanUtils.copyProperties(main, vo);
          List<IostDeliverstatusList> iostDeliverstatusListList = iostDeliverstatusListService.selectByMainId(main.getId());
          vo.setIostDeliverstatusListList(iostDeliverstatusListList);
          pageList.add(vo);
      }

      // Step.4 AutoPoi 导出Excel
      ModelAndView mv = new ModelAndView(new JeecgEntityExcelView());
      mv.addObject(NormalExcelConstants.FILE_NAME, "更新物流状态列表");
      mv.addObject(NormalExcelConstants.CLASS, IostDeliverstatusPage.class);
      mv.addObject(NormalExcelConstants.PARAMS, new ExportParams("更新物流状态数据", "导出人:"+sysUser.getRealname(), "更新物流状态"));
      mv.addObject(NormalExcelConstants.DATA_LIST, pageList);
      return mv;
    }

    /**
    * 通过excel导入数据
    *
    * @param request
    * @param response
    * @return
    */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
      MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
      Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
      for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
          MultipartFile file = entity.getValue();// 获取上传文件对象
          ImportParams params = new ImportParams();
          params.setTitleRows(2);
          params.setHeadRows(1);
          params.setNeedSave(true);
          try {
              List<IostDeliverstatusPage> list = ExcelImportUtil.importExcel(file.getInputStream(), IostDeliverstatusPage.class, params);
              for (IostDeliverstatusPage page : list) {
                  IostDeliverstatus po = new IostDeliverstatus();
                  BeanUtils.copyProperties(page, po);
                  iostDeliverstatusService.saveMain(po, page.getIostDeliverstatusListList());
              }
              return Result.OK("文件导入成功！数据行数:" + list.size());
          } catch (Exception e) {
              log.error(e.getMessage(),e);
              return Result.error("文件导入失败:"+e.getMessage());
          } finally {
              try {
                  file.getInputStream().close();
              } catch (IOException e) {
                  e.printStackTrace();
              }
          }
      }
      return Result.OK("文件导入失败！");
    }

}
