package org.jeecg.modules.iost.basedata.controller;

import java.io.UnsupportedEncodingException;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.jeecg.common.system.vo.LoginUser;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.iost.basedata.entity.IostInventoryRecordList;
import org.jeecg.modules.iost.basedata.entity.IostInventoryRecord;
import org.jeecg.modules.iost.basedata.vo.IostInventoryRecordPage;
import org.jeecg.modules.iost.basedata.service.IIostInventoryRecordService;
import org.jeecg.modules.iost.basedata.service.IIostInventoryRecordListService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;

 /**
 * @Description: 库存记录
 * @Author: jeecg-boot
 * @Date:   2020-11-10
 * @Version: V1.0
 */
@Api(tags="库存记录")
@RestController
@RequestMapping("/basedata/iostInventoryRecord")
@Slf4j
public class IostInventoryRecordController {
	@Autowired
	private IIostInventoryRecordService iostInventoryRecordService;
	@Autowired
	private IIostInventoryRecordListService iostInventoryRecordListService;
	
	/**
	 * 分页列表查询
	 *
	 * @param iostInventoryRecord
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	@AutoLog(value = "库存记录-分页列表查询")
	@ApiOperation(value="库存记录-分页列表查询", notes="库存记录-分页列表查询")
	@GetMapping(value = "/list")
	public Result<?> queryPageList(IostInventoryRecord iostInventoryRecord,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<IostInventoryRecord> queryWrapper = QueryGenerator.initQueryWrapper(iostInventoryRecord, req.getParameterMap());
		Page<IostInventoryRecord> page = new Page<IostInventoryRecord>(pageNo, pageSize);
		IPage<IostInventoryRecord> pageList = iostInventoryRecordService.page(page, queryWrapper);
		return Result.OK(pageList);
	}
	
	/**
	 *   添加
	 *
	 * @param iostInventoryRecordPage
	 * @return
	 */
	@AutoLog(value = "库存记录-添加")
	@ApiOperation(value="库存记录-添加", notes="库存记录-添加")
	@PostMapping(value = "/add")
	public Result<?> add(@RequestBody IostInventoryRecordPage iostInventoryRecordPage) {
		IostInventoryRecord iostInventoryRecord = new IostInventoryRecord();
		BeanUtils.copyProperties(iostInventoryRecordPage, iostInventoryRecord);
		iostInventoryRecordService.saveMain(iostInventoryRecord, iostInventoryRecordPage.getIostInventoryRecordListList());
		return Result.OK("添加成功！");
	}
	
	/**
	 *  编辑
	 *
	 * @param iostInventoryRecordPage
	 * @return
	 */
	@AutoLog(value = "库存记录-编辑")
	@ApiOperation(value="库存记录-编辑", notes="库存记录-编辑")
	@PutMapping(value = "/edit")
	public Result<?> edit(@RequestBody IostInventoryRecordPage iostInventoryRecordPage) {
		IostInventoryRecord iostInventoryRecord = new IostInventoryRecord();
		BeanUtils.copyProperties(iostInventoryRecordPage, iostInventoryRecord);
		IostInventoryRecord iostInventoryRecordEntity = iostInventoryRecordService.getById(iostInventoryRecord.getId());
		if(iostInventoryRecordEntity==null) {
			return Result.error("未找到对应数据");
		}
		iostInventoryRecordService.updateMain(iostInventoryRecord, iostInventoryRecordPage.getIostInventoryRecordListList());
		return Result.OK("编辑成功!");
	}
	
	/**
	 *   通过id删除
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "库存记录-通过id删除")
	@ApiOperation(value="库存记录-通过id删除", notes="库存记录-通过id删除")
	@DeleteMapping(value = "/delete")
	public Result<?> delete(@RequestParam(name="id",required=true) String id) {
		iostInventoryRecordService.delMain(id);
		return Result.OK("删除成功!");
	}
	
	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "库存记录-批量删除")
	@ApiOperation(value="库存记录-批量删除", notes="库存记录-批量删除")
	@DeleteMapping(value = "/deleteBatch")
	public Result<?> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.iostInventoryRecordService.delBatchMain(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功！");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "库存记录-通过id查询")
	@ApiOperation(value="库存记录-通过id查询", notes="库存记录-通过id查询")
	@GetMapping(value = "/queryById")
	public Result<?> queryById(@RequestParam(name="id",required=true) String id) {
		IostInventoryRecord iostInventoryRecord = iostInventoryRecordService.getById(id);
		if(iostInventoryRecord==null) {
			return Result.error("未找到对应数据");
		}
		return Result.OK(iostInventoryRecord);

	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "库存记录表通过主表ID查询")
	@ApiOperation(value="库存记录表主表ID查询", notes="库存记录表-通主表ID查询")
	@GetMapping(value = "/queryIostInventoryRecordListByMainId")
	public Result<?> queryIostInventoryRecordListListByMainId(@RequestParam(name="id",required=true) String id) {
		List<IostInventoryRecordList> iostInventoryRecordListList = iostInventoryRecordListService.selectByMainId(id);
		return Result.OK(iostInventoryRecordListList);
	}

    /**
    * 导出excel
    *
    * @param request
    * @param iostInventoryRecord
    */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, IostInventoryRecord iostInventoryRecord) {
      // Step.1 组装查询条件查询数据
      QueryWrapper<IostInventoryRecord> queryWrapper = QueryGenerator.initQueryWrapper(iostInventoryRecord, request.getParameterMap());
      LoginUser sysUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();

      //Step.2 获取导出数据
      List<IostInventoryRecord> queryList = iostInventoryRecordService.list(queryWrapper);
      // 过滤选中数据
      String selections = request.getParameter("selections");
      List<IostInventoryRecord> iostInventoryRecordList = new ArrayList<IostInventoryRecord>();
      if(oConvertUtils.isEmpty(selections)) {
          iostInventoryRecordList = queryList;
      }else {
          List<String> selectionList = Arrays.asList(selections.split(","));
          iostInventoryRecordList = queryList.stream().filter(item -> selectionList.contains(item.getId())).collect(Collectors.toList());
      }

      // Step.3 组装pageList
      List<IostInventoryRecordPage> pageList = new ArrayList<IostInventoryRecordPage>();
      for (IostInventoryRecord main : iostInventoryRecordList) {
          IostInventoryRecordPage vo = new IostInventoryRecordPage();
          BeanUtils.copyProperties(main, vo);
          List<IostInventoryRecordList> iostInventoryRecordListList = iostInventoryRecordListService.selectByMainId(main.getId());
          vo.setIostInventoryRecordListList(iostInventoryRecordListList);
          pageList.add(vo);
      }

      // Step.4 AutoPoi 导出Excel
      ModelAndView mv = new ModelAndView(new JeecgEntityExcelView());
      mv.addObject(NormalExcelConstants.FILE_NAME, "库存记录列表");
      mv.addObject(NormalExcelConstants.CLASS, IostInventoryRecordPage.class);
      mv.addObject(NormalExcelConstants.PARAMS, new ExportParams("库存记录数据", "导出人:"+sysUser.getRealname(), "库存记录"));
      mv.addObject(NormalExcelConstants.DATA_LIST, pageList);
      return mv;
    }

    /**
    * 通过excel导入数据
    *
    * @param request
    * @param response
    * @return
    */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
      MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
      Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
      for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
          MultipartFile file = entity.getValue();// 获取上传文件对象
          ImportParams params = new ImportParams();
          params.setTitleRows(2);
          params.setHeadRows(1);
          params.setNeedSave(true);
          try {
              List<IostInventoryRecordPage> list = ExcelImportUtil.importExcel(file.getInputStream(), IostInventoryRecordPage.class, params);
              for (IostInventoryRecordPage page : list) {
                  IostInventoryRecord po = new IostInventoryRecord();
                  BeanUtils.copyProperties(page, po);
                  iostInventoryRecordService.saveMain(po, page.getIostInventoryRecordListList());
              }
              return Result.OK("文件导入成功！数据行数:" + list.size());
          } catch (Exception e) {
              log.error(e.getMessage(),e);
              return Result.error("文件导入失败:"+e.getMessage());
          } finally {
              try {
                  file.getInputStream().close();
              } catch (IOException e) {
                  e.printStackTrace();
              }
          }
      }
      return Result.OK("文件导入失败！");
    }

}
