package org.jeecg.modules.iost.basedata.controller;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.iost.basedata.entity.IostPrice;
import org.jeecg.modules.iost.basedata.service.IIostPriceService;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;

import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.jeecg.common.system.base.controller.JeecgController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;

 /**
 * @Description: 价格维护
 * @Author: jeecg-boot
 * @Date:   2020-12-15
 * @Version: V1.0
 */
@Api(tags="价格维护")
@RestController
@RequestMapping("/basedata/iostPrice")
@Slf4j
public class IostPriceController extends JeecgController<IostPrice, IIostPriceService> {
	@Autowired
	private IIostPriceService iostPriceService;
	
	/**
	 * 分页列表查询
	 *
	 * @param iostPrice
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	@AutoLog(value = "价格维护-分页列表查询")
	@ApiOperation(value="价格维护-分页列表查询", notes="价格维护-分页列表查询")
	@GetMapping(value = "/list")
	public Result<?> queryPageList(IostPrice iostPrice,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<IostPrice> queryWrapper = QueryGenerator.initQueryWrapper(iostPrice, req.getParameterMap());
		Page<IostPrice> page = new Page<IostPrice>(pageNo, pageSize);
		IPage<IostPrice> pageList = iostPriceService.page(page, queryWrapper);
		return Result.OK(pageList);
	}
	
	/**
	 *   添加
	 *
	 * @param iostPrice
	 * @return
	 */
	@AutoLog(value = "价格维护-添加")
	@ApiOperation(value="价格维护-添加", notes="价格维护-添加")
	@PostMapping(value = "/add")
	public Result<?> add(@RequestBody IostPrice iostPrice) {
		iostPriceService.save(iostPrice);
		return Result.OK("添加成功！");
	}
	
	/**
	 *  编辑
	 *
	 * @param iostPrice
	 * @return
	 */
	@AutoLog(value = "价格维护-编辑")
	@ApiOperation(value="价格维护-编辑", notes="价格维护-编辑")
	@PutMapping(value = "/edit")
	public Result<?> edit(@RequestBody IostPrice iostPrice) {
		iostPriceService.updateById(iostPrice);
		return Result.OK("编辑成功!");
	}
	
	/**
	 *   通过id删除
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "价格维护-通过id删除")
	@ApiOperation(value="价格维护-通过id删除", notes="价格维护-通过id删除")
	@DeleteMapping(value = "/delete")
	public Result<?> delete(@RequestParam(name="id",required=true) String id) {
		iostPriceService.removeById(id);
		return Result.OK("删除成功!");
	}
	
	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "价格维护-批量删除")
	@ApiOperation(value="价格维护-批量删除", notes="价格维护-批量删除")
	@DeleteMapping(value = "/deleteBatch")
	public Result<?> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.iostPriceService.removeByIds(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功!");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "价格维护-通过id查询")
	@ApiOperation(value="价格维护-通过id查询", notes="价格维护-通过id查询")
	@GetMapping(value = "/queryById")
	public Result<?> queryById(@RequestParam(name="id",required=true) String id) {
		IostPrice iostPrice = iostPriceService.getById(id);
		if(iostPrice==null) {
			return Result.error("未找到对应数据");
		}
		return Result.OK(iostPrice);
	}

    /**
    * 导出excel
    *
    * @param request
    * @param iostPrice
    */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, IostPrice iostPrice) {
        return super.exportXls(request, iostPrice, IostPrice.class, "价格维护");
    }

    /**
      * 通过excel导入数据
    *
    * @param request
    * @param response
    * @return
    */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, IostPrice.class);
    }

}
