package org.jeecg.modules.iost.basedata.controller;

import java.io.UnsupportedEncodingException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jeecg.modules.iost.basedata.entity.IostReceivinglist;
import org.jeecg.modules.iost.basedata.entity.IostSummarySheetList;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.jeecg.common.system.vo.LoginUser;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.iost.basedata.entity.IostReceivingNoteList;
import org.jeecg.modules.iost.basedata.entity.IostReceivingNote;
import org.jeecg.modules.iost.basedata.vo.IostReceivingNotePage;
import org.jeecg.modules.iost.basedata.service.IIostReceivingNoteService;
import org.jeecg.modules.iost.basedata.service.IIostReceivingNoteListService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ResourceUtils;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;

 /**
 * @Description: 收费单
 * @Author: jeecg-boot
 * @Date:   2020-12-22
 * @Version: V1.0
 */
@Api(tags="收费单")
@RestController
@RequestMapping("/basedata/iostReceivingNote")
@Slf4j
public class IostReceivingNoteController {
	@Autowired
	private IIostReceivingNoteService iostReceivingNoteService;
	@Autowired
	private IIostReceivingNoteListService iostReceivingNoteListService;
	
	/**
	 * 分页列表查询
	 *
	 * @param iostReceivingNote
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	@AutoLog(value = "收费单-分页列表查询")
	@ApiOperation(value="收费单-分页列表查询", notes="收费单-分页列表查询")
	@GetMapping(value = "/list")
	public Result<?> queryPageList(IostReceivingNote iostReceivingNote,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<IostReceivingNote> queryWrapper = QueryGenerator.initQueryWrapper(iostReceivingNote, req.getParameterMap());
		Page<IostReceivingNote> page = new Page<IostReceivingNote>(pageNo, pageSize);
		IPage<IostReceivingNote> pageList = iostReceivingNoteService.page(page, queryWrapper);
		return Result.OK(pageList);
	}



	/**
	 *   添加
	 *
	 * @param iostReceivingNotePage
	 * @return
	 */
	@AutoLog(value = "收费单-添加")
	@ApiOperation(value="收费单-添加", notes="收费单-添加")
	@PostMapping(value = "/add")
	public Result<?> add(@RequestBody IostReceivingNotePage iostReceivingNotePage) {
		IostReceivingNote iostReceivingNote = new IostReceivingNote();
		BeanUtils.copyProperties(iostReceivingNotePage, iostReceivingNote);
		iostReceivingNoteService.saveMain(iostReceivingNote, iostReceivingNotePage.getIostReceivingNoteListList());
		return Result.OK("添加成功！");
	}

	@AutoLog(value = "收费单-下载报表")
    @GetMapping("/exportReceivingNotePdf")
    @ApiOperation(value = "下载收费单报表（pdf）")
    public void exportReceivingNotePdf(HttpServletResponse response, @RequestParam(name="deliveryRecordId",required=true) String deliveryRecordId) throws IOException, DocumentException {

    	QueryWrapper<IostReceivingNote> iostReceivingNoteQueryWrapper = new QueryWrapper<>();
    	iostReceivingNoteQueryWrapper.eq("delivery_record_id", deliveryRecordId);
    	
    	List<IostReceivingNote> iostReceivingNotes = iostReceivingNoteService.list(iostReceivingNoteQueryWrapper);
    	
    	List<String> iostReceivingNoteIds = new ArrayList<String>();
    	for(IostReceivingNote iostReceivingNote:iostReceivingNotes)
    	{
    		iostReceivingNoteIds.add(iostReceivingNote.getId());
    	}
    	
    	List<IostReceivingNoteList> iostReceivingNoteLists = new  ArrayList<IostReceivingNoteList>();
    	if(!iostReceivingNoteIds.isEmpty())
    	{
        	QueryWrapper<IostReceivingNoteList> queryWrapper = new QueryWrapper<>();
            queryWrapper
                    .in("receiving_note_id", iostReceivingNoteIds);
    		iostReceivingNoteLists = iostReceivingNoteListService.list(queryWrapper);
    	}
    	 
        //设置文件名、响应头
        String fileName = "收费单";
        response.setContentType("application/x-download");
        response.addHeader("Content-Disposition", "attachment;filename="+new String(fileName.getBytes("utf-8"), "ISO8859-1" )+".pdf");

        //Create Document Instance
        Document document = new Document(PageSize.A4);

        //加载字体
        BaseFont bfChinese = BaseFont.createFont("/wmssystem/config/res/stsong.ttf", BaseFont.IDENTITY_H, BaseFont.NOT_EMBEDDED);

        //字体
        Font titleFont = new Font(bfChinese, 22, Font.BOLD);
        Font keyFont = new Font(bfChinese, 13, Font.NORMAL);
        Font textFont = new Font(bfChinese, 11, Font.NORMAL);
        Font smtextFont = new Font(bfChinese, 6, Font.NORMAL);

        //Create Writer associated with document
        PdfWriter.getInstance(document, response.getOutputStream());
        document.open();
        if(iostReceivingNotes.size() == 0)
        {
            document.newPage();
            addTitleAndDateInfo(document, titleFont, keyFont, textFont);
        }
        for(IostReceivingNote iostReceivingNote:iostReceivingNotes)
        {
            document.newPage();

            //加载标题、日期
            addTitleAndDateInfo(document, titleFont, keyFont, smtextFont);
        	List<IostReceivingNoteList> iostReceivingNoteListList = new ArrayList< IostReceivingNoteList>();
        	
        	for(IostReceivingNoteList iostReceivingNoteList:iostReceivingNoteLists)
        	{
        		if(!iostReceivingNoteList.getReceivingNoteId().equals(iostReceivingNote.getId())) continue;
        		
        		iostReceivingNoteListList.add(iostReceivingNoteList);
        	}
        	addHeadField(document, iostReceivingNote, textFont, keyFont);
            //添加统计表格信息
        	addEntryTable(document, iostReceivingNoteListList, keyFont, textFont);
        	addEndInfo(document, textFont);
        }
        //关闭流
        document.close();

    }
	
	private void addEndInfo(Document document, Font textFont) throws DocumentException
	{        
		//列数为1的表格
        PdfPTable t = new PdfPTable(1);
	    t.setWidthPercentage(100F);
        PdfPCell c1 = new PdfPCell(new Paragraph("", textFont));
        c1.setHorizontalAlignment(Element.ALIGN_LEFT); //水平居中
        c1.setFixedHeight(15);
        c1.setBorder(PdfPCell.NO_BORDER);  //不要边框
        t.addCell(c1);
        
        c1 = new PdfPCell(new Paragraph("备注", textFont));
        c1.setHorizontalAlignment(Element.ALIGN_LEFT); //水平居中
        c1.setBorder(PdfPCell.NO_BORDER);  //不要边框
        t.addCell(c1);

        c1 = new PdfPCell(new Paragraph("１. 以约堡市中心为准，１５公里范围内，免费送货。超出距离收取送货费。", textFont));
        c1.setHorizontalAlignment(Element.ALIGN_LEFT); //水平居中
        c1.setBorder(PdfPCell.NO_BORDER);  //不要边框
        t.addCell(c1);
        

        c1 = new PdfPCell(new Paragraph("２. 每立方米限重380公斤，超重按重量计算（每立方米单价/380*重量=实际价格）", textFont));
        c1.setHorizontalAlignment(Element.ALIGN_LEFT); //水平居中
        c1.setBorder(PdfPCell.NO_BORDER);  //不要边框
        t.addCell(c1);

        c1 = new PdfPCell(new Paragraph("３. 如果有整箱货物丢失按照５倍运费赔偿，如需购买保险请在发货时联系相关人员。", textFont));
        c1.setHorizontalAlignment(Element.ALIGN_LEFT); //水平居中
        c1.setBorder(PdfPCell.NO_BORDER);  //不要边框
        t.addCell(c1);

        c1 = new PdfPCell(new Paragraph("４. 货物体积不足0.5CBM，运费按0.5CBM计算。", textFont));
        c1.setHorizontalAlignment(Element.ALIGN_LEFT); //水平居中
        c1.setBorder(PdfPCell.NO_BORDER);  //不要边框
        t.addCell(c1);
        
        document.add(t);   //把表格t添加进document中
	}
	
    /**
     * 方法描述: 添加大标题和日期
     */
    private void addTitleAndDateInfo(Document document, Font titleFont, Font keyFont, Font textFont) throws DocumentException {

        //列数为1的表格
        PdfPTable t = new PdfPTable(1);
        t.setWidthPercentage(100F);  //设置表格宽度 100%
        //大标题，用titleFont字体：20号字加粗
        PdfPCell c1 = new PdfPCell(new Paragraph("志成散货", textFont));
        c1.setHorizontalAlignment(Element.ALIGN_CENTER); //水平居中
        c1.setBorder(PdfPCell.BOTTOM);  //不要边框
        t.addCell(c1);

        c1 = new PdfPCell(); 
        c1.setBorder(PdfPCell.NO_BORDER); 
        c1.setFixedHeight(15); 
        t.addCell(c1);

        
        c1 = new PdfPCell(new Paragraph("收费单", titleFont));
        c1.setHorizontalAlignment(Element.ALIGN_CENTER); //水平居中
        c1.setBorder(PdfPCell.NO_BORDER);  //不要边框
        t.addCell(c1);
        document.add(t);   //把表格t添加进document中
    }
    
    private void addHeadField(Document document, IostReceivingNote iostReceivingNote, Font textFont, Font keyFont) throws DocumentException
    {        
    	PdfPTable headTable = new PdfPTable(2);
	    float[] widths = {50f,50f};
	    headTable.setWidths(widths);
	    headTable.setWidthPercentage(100F);

        //加一行空行，设置高度，让标题和日期之间有点儿上下间距
        PdfPCell blankCell = new PdfPCell(); blankCell.setBorder(PdfPCell.NO_BORDER); blankCell.setFixedHeight(15); blankCell.setColspan(6); headTable.addCell(blankCell);

        PdfPCell c2Title = new PdfPCell(new Paragraph("发票号:  "+iostReceivingNote.getInvoiceNumber(), keyFont)); c2Title.setHorizontalAlignment(Element.ALIGN_LEFT); c2Title.setBorder(PdfPCell.NO_BORDER);c2Title.setPaddingLeft(10f);headTable.addCell(c2Title);
        //c2Title = new PdfPCell(new Paragraph(iostReceivingNote.getInvoiceNumber(), textFont)); c2Title.setHorizontalAlignment(Element.ALIGN_LEFT);c2Title.setBorder(PdfPCell.BOTTOM);headTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph("入仓号:  "+iostReceivingNote.getReceivingNo(), keyFont)); c2Title.setHorizontalAlignment(Element.ALIGN_LEFT); c2Title.setBorder(PdfPCell.NO_BORDER);c2Title.setPaddingLeft(10f);headTable.addCell(c2Title);
        //c2Title = new PdfPCell(new Paragraph(iostReceivingNote.getReceivingNo(), textFont)); c2Title.setHorizontalAlignment(Element.ALIGN_LEFT); c2Title.setBorder(PdfPCell.BOTTOM);headTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph("客户姓名:  "+iostReceivingNote.getCustomerName(), keyFont)); c2Title.setHorizontalAlignment(Element.ALIGN_LEFT);c2Title.setBorder(PdfPCell.NO_BORDER);c2Title.setPaddingLeft(10f); headTable.addCell(c2Title);
        //c2Title = new PdfPCell(new Paragraph(iostReceivingNote.getCustomerName(), textFont)); c2Title.setHorizontalAlignment(Element.ALIGN_LEFT); c2Title.setBorder(PdfPCell.BOTTOM);headTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph("联系电话:  "+iostReceivingNote.getTelephone(), keyFont)); c2Title.setHorizontalAlignment(Element.ALIGN_LEFT); c2Title.setBorder(PdfPCell.NO_BORDER);c2Title.setPaddingLeft(10f);headTable.addCell(c2Title);
        //c2Title = new PdfPCell(new Paragraph(iostReceivingNote.getTelephone(), textFont)); c2Title.setHorizontalAlignment(Element.ALIGN_LEFT); c2Title.setBorder(PdfPCell.BOTTOM);headTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph("送货地址:  "+iostReceivingNote.getDeliveryAddress(), keyFont)); c2Title.setHorizontalAlignment(Element.ALIGN_LEFT); c2Title.setBorder(PdfPCell.NO_BORDER);c2Title.setColspan(2);c2Title.setPaddingLeft(10f);headTable.addCell(c2Title);
        //c2Title = new PdfPCell(new Paragraph(iostReceivingNote.getDeliveryAddress(), textFont)); c2Title.setHorizontalAlignment(Element.ALIGN_LEFT); c2Title.setColspan(3); c2Title.setBorder(PdfPCell.BOTTOM);headTable.addCell(c2Title);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = formatter.format(iostReceivingNote.getCreateTime());
        c2Title = new PdfPCell(new Paragraph("日期:  "+dateString, keyFont)); c2Title.setHorizontalAlignment(Element.ALIGN_LEFT); c2Title.setBorder(PdfPCell.NO_BORDER);c2Title.setColspan(2);c2Title.setPaddingLeft(10f);headTable.addCell(c2Title);
        //c2Title = new PdfPCell(new Paragraph(dateString, keyFont)); c2Title.setHorizontalAlignment(Element.ALIGN_LEFT); c2Title.setColspan(3); c2Title.setBorder(PdfPCell.BOTTOM);headTable.addCell(c2Title);
	    
        document.add(headTable);   //把表格t添加进document中
    }
    

    /**
     * 增加单据体信息
     * @param document
     * @param iostReceivingNoteLists
     * @param textFont
     * @throws DocumentException
     */
    private void addEntryTable(Document document, List<IostReceivingNoteList> iostReceivingNoteLists, Font keyFont, Font textFont) throws DocumentException {
        PdfPTable entryTable = new PdfPTable(7);
        float[] widths = {2f,2f, 1f, 1f, 1f, 1f, 1f};
        entryTable.setWidths(widths);
        entryTable.setWidthPercentage(100F);

        //加一行空行，设置高度，让标题和日期之间有点儿上下间距
        PdfPCell blankCell = new PdfPCell(); blankCell.setBorder(PdfPCell.NO_BORDER); blankCell.setFixedHeight(15); blankCell.setColspan(7); entryTable.addCell(blankCell);
        //设置表头
        PdfPCell c2Title = new PdfPCell(new Paragraph("商品中文名称", keyFont)); c2Title.setHorizontalAlignment(Element.ALIGN_CENTER);c2Title.setVerticalAlignment(Element.ALIGN_MIDDLE);c2Title.setPaddingBottom(5);entryTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph("商品英文名称", keyFont)); c2Title.setHorizontalAlignment(Element.ALIGN_CENTER);c2Title.setVerticalAlignment(Element.ALIGN_MIDDLE);entryTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph("体积", keyFont)); c2Title.setHorizontalAlignment(Element.ALIGN_CENTER);c2Title.setVerticalAlignment(Element.ALIGN_MIDDLE); entryTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph("重量", keyFont)); c2Title.setHorizontalAlignment(Element.ALIGN_CENTER);c2Title.setVerticalAlignment(Element.ALIGN_MIDDLE); entryTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph("箱数", keyFont)); c2Title.setHorizontalAlignment(Element.ALIGN_CENTER);c2Title.setVerticalAlignment(Element.ALIGN_MIDDLE); entryTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph("价格", keyFont)); c2Title.setHorizontalAlignment(Element.ALIGN_CENTER);c2Title.setVerticalAlignment(Element.ALIGN_MIDDLE); entryTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph("金额", keyFont)); c2Title.setHorizontalAlignment(Element.ALIGN_CENTER);c2Title.setVerticalAlignment(Element.ALIGN_MIDDLE); entryTable.addCell(c2Title);

        double volumes = 0;
        double weights = 0;
        int packages = 0;
        double money = 0;
        //设置表内容
        for (int i = 0; i < iostReceivingNoteLists.size(); i++) {
        	IostReceivingNoteList iostReceivingNoteList = iostReceivingNoteLists.get(i);
            //商品名称
        	String nameChs = "";
        	if(iostReceivingNoteList.getNameChs() != null)
        	{
        		nameChs = iostReceivingNoteList.getNameChs();
        	}
            PdfPCell c2 = new PdfPCell(new Paragraph(nameChs, textFont));
            c2.setHorizontalAlignment(Element.ALIGN_CENTER);
            c2.setVerticalAlignment(Element.ALIGN_MIDDLE);
            c2.setPaddingBottom(5);
            entryTable.addCell(c2);
            
            String nameEng = "";
        	if(iostReceivingNoteList.getNameEng() != null)
        	{
        		nameEng = iostReceivingNoteList.getNameEng();
        	}
            c2 = new PdfPCell(new Paragraph(nameEng, textFont));
            c2.setHorizontalAlignment(Element.ALIGN_CENTER);  
            entryTable.addCell(c2);
            
            Double volumn = 0.0;
            if(iostReceivingNoteList.getVolume() != null)
            {
            	volumn = iostReceivingNoteList.getVolume();
            }
            //体积
            c2 = new PdfPCell(new Paragraph(String.format("%.2f", volumn), textFont));
            c2.setHorizontalAlignment(Element.ALIGN_CENTER);  
            entryTable.addCell(c2);
            if(iostReceivingNoteList.getVolume() != null)
            {
            	volumes += iostReceivingNoteList.getVolume();
            }

            Double weight = 0.0;
            if(iostReceivingNoteList.getWeight() != null)
            {
            	weight = iostReceivingNoteList.getWeight();
            }
            //重量
            c2 = new PdfPCell(new Paragraph(String.format("%.2f", weight), textFont));
            c2.setHorizontalAlignment(Element.ALIGN_CENTER);  
            entryTable.addCell(c2);
            if(iostReceivingNoteList.getWeight() != null)
            {
            	weights += iostReceivingNoteList.getWeight();
            }

            //箱数
            Integer curPackages = 0;
            if(iostReceivingNoteList.getPackages() != null)
            {
            	curPackages = iostReceivingNoteList.getPackages();
            }
            c2 = new PdfPCell(new Paragraph(String.format("%d", curPackages), textFont));
            c2.setHorizontalAlignment(Element.ALIGN_CENTER);  
            entryTable.addCell(c2);
            if(iostReceivingNoteList.getPackages() != null)
            {
            	packages += iostReceivingNoteList.getPackages();
            }
            
            Double price = 0.0;
            if(iostReceivingNoteList.getPrice() != null)
            {
            	price = iostReceivingNoteList.getPrice() ;
            }
            //价格
            c2 = new PdfPCell(new Paragraph(String.format("%.2f", price), textFont));
            c2.setHorizontalAlignment(Element.ALIGN_CENTER);  
            entryTable.addCell(c2);

            double curMoney = 0.0;
            if(iostReceivingNoteList.getMoney() != null)
            {
            	curMoney = iostReceivingNoteList.getMoney();
            }
            //金额
            c2 = new PdfPCell(new Paragraph(String.format("%.2f", curMoney), textFont));
            c2.setHorizontalAlignment(Element.ALIGN_CENTER);  
            entryTable.addCell(c2);
            if(iostReceivingNoteList.getMoney() != null)
            {
            	money += iostReceivingNoteList.getMoney();
            }
        }

        //商品名称
        PdfPCell c2 = new PdfPCell(new Paragraph("Total", textFont));
        c2.setHorizontalAlignment(Element.ALIGN_CENTER);  
        entryTable.addCell(c2);
        
        //体积
        c2 = new PdfPCell(new Paragraph(String.format("%.2f", volumes), textFont));
        c2.setHorizontalAlignment(Element.ALIGN_CENTER);  
        entryTable.addCell(c2);

        //重量
        c2 = new PdfPCell(new Paragraph(String.format("%.2f", weights), textFont));
        c2.setHorizontalAlignment(Element.ALIGN_CENTER);  
        entryTable.addCell(c2);

        //箱数
        c2 = new PdfPCell(new Paragraph(String.valueOf(packages), textFont));
        c2.setHorizontalAlignment(Element.ALIGN_CENTER);  
        entryTable.addCell(c2);
        
        //价格
        c2 = new PdfPCell(new Paragraph("", textFont));
        c2.setHorizontalAlignment(Element.ALIGN_CENTER);  
        entryTable.addCell(c2);

        //金额
        c2 = new PdfPCell(new Paragraph(String.format("%.2f", money), textFont));
        c2.setHorizontalAlignment(Element.ALIGN_CENTER);  
        entryTable.addCell(c2);
        //添加统计数据表
        document.add(entryTable);
    }
	
	/**
	 *  编辑
	 *
	 * @param iostReceivingNotePage
	 * @return
	 */
	@AutoLog(value = "收费单-编辑")
	@ApiOperation(value="收费单-编辑", notes="收费单-编辑")
	@PutMapping(value = "/edit")
	public Result<?> edit(@RequestBody IostReceivingNotePage iostReceivingNotePage) {
		IostReceivingNote iostReceivingNote = new IostReceivingNote();
		BeanUtils.copyProperties(iostReceivingNotePage, iostReceivingNote);
		IostReceivingNote iostReceivingNoteEntity = iostReceivingNoteService.getById(iostReceivingNote.getId());
		if(iostReceivingNoteEntity==null) {
			return Result.error("未找到对应数据");
		}
		iostReceivingNoteService.updateMain(iostReceivingNote, iostReceivingNotePage.getIostReceivingNoteListList());
		return Result.OK("编辑成功!");
	}
	
	/**
	 *   通过id删除
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "收费单-通过id删除")
	@ApiOperation(value="收费单-通过id删除", notes="收费单-通过id删除")
	@DeleteMapping(value = "/delete")
	@RequiresPermissions("receivingNote:delete")
	public Result<?> delete(@RequestParam(name="id",required=true) String id) {
		iostReceivingNoteService.delMain(id);
		return Result.OK("删除成功!");
	}
	
	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "收费单-批量删除")
	@ApiOperation(value="收费单-批量删除", notes="收费单-批量删除")
	@DeleteMapping(value = "/deleteBatch")
	@RequiresPermissions("receivingNote:delete")
	public Result<?> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.iostReceivingNoteService.delBatchMain(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功！");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "收费单-通过id查询")
	@ApiOperation(value="收费单-通过id查询", notes="收费单-通过id查询")
	@GetMapping(value = "/queryById")
	public Result<?> queryById(@RequestParam(name="id",required=true) String id) {
		IostReceivingNote iostReceivingNote = iostReceivingNoteService.getById(id);
		if(iostReceivingNote==null) {
			return Result.error("未找到对应数据");
		}
		return Result.OK(iostReceivingNote);

	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "收费明细通过主表ID查询")
	@ApiOperation(value="收费明细主表ID查询", notes="收费明细-通主表ID查询")
	@GetMapping(value = "/queryIostReceivingNoteListByMainId")
	public Result<?> queryIostReceivingNoteListListByMainId(@RequestParam(name="id",required=true) String id) {
		List<IostReceivingNoteList> iostReceivingNoteListList = iostReceivingNoteListService.selectByMainId(id);
		return Result.OK(iostReceivingNoteListList);
	}

     /**
      * 打印收费单
      *
      * @param id
      * @return
      */
     @AutoLog(value = "打印收费单")
     @ApiOperation(value="打印收费单", notes="收费明细-打印收费单")
     @GetMapping(value = "/queryIostReceivingNotIostReceivingNotListByMainId")
     public Result<?> queryIostReceivingNoteListListMainId(@RequestParam(name="id",required=true) String id) {
         List<IostReceivingNoteList> iostReceivingNoteListList = iostReceivingNoteListService.selectByMainId(id);
         addSumRow(iostReceivingNoteListList);
         return Result.OK(iostReceivingNoteListList);
     }

     /***
      * 增加统计行
      * @param iostIostReceivingNoteList
      */
     private void addSumRow(List<IostReceivingNoteList> iostIostReceivingNoteList)
     {
         double totlevolume = 0;//体积总
         double totleWeightTotal = 0;//重量总
         int totlePackagesTotal = 0;//箱数总
         double totlePrice = 0;//价格总
         double totleMoney = 0;//金额总
         for(IostReceivingNoteList iostReceivingNoteList: iostIostReceivingNoteList)
         {
             BigDecimal A1 = new BigDecimal(Double.toString(totlevolume));
             BigDecimal A2 = new BigDecimal(Double.toString(iostReceivingNoteList.getVolume()));
             totlevolume = A1.add(A2).doubleValue();
             A1 = new BigDecimal(Double.toString(totleWeightTotal));
             A2 = new BigDecimal(Double.toString(iostReceivingNoteList.getWeight()));
             totleWeightTotal = A1.add(A2).doubleValue();
             totlePackagesTotal = totlePackagesTotal + iostReceivingNoteList.getPackages();
             A1 = new BigDecimal(Double.toString(totlePrice));
             A2 = new BigDecimal(Double.toString(iostReceivingNoteList.getPrice()));
             totlePrice = A1.add(A2).doubleValue();
             A1 = new BigDecimal(Double.toString(totleMoney));
             A2 = new BigDecimal(Double.toString(iostReceivingNoteList.getMoney()));
             totleMoney = A1.add(A2).doubleValue();
         }

         IostReceivingNoteList iostReceivingNoteList = new IostReceivingNoteList();
         iostReceivingNoteList.setNameChs("总和");
         iostReceivingNoteList.setVolume(totlevolume);
         iostReceivingNoteList.setWeight(totleWeightTotal);
         iostReceivingNoteList.setPackages(totlePackagesTotal);
         iostReceivingNoteList.setPrice(totlePrice);
         iostReceivingNoteList.setMoney(totleMoney);
         iostIostReceivingNoteList.add(iostReceivingNoteList);
     }
	
    /**
    * 导出excel
    *
    * @param request
    * @param iostReceivingNote
    */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, IostReceivingNote iostReceivingNote) {
      // Step.1 组装查询条件查询数据
      QueryWrapper<IostReceivingNote> queryWrapper = QueryGenerator.initQueryWrapper(iostReceivingNote, request.getParameterMap());
      LoginUser sysUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();

      //Step.2 获取导出数据
      List<IostReceivingNote> queryList = iostReceivingNoteService.list(queryWrapper);
      // 过滤选中数据
      String selections = request.getParameter("selections");
      List<IostReceivingNote> iostReceivingNoteList = new ArrayList<IostReceivingNote>();
      if(oConvertUtils.isEmpty(selections)) {
          iostReceivingNoteList = queryList;
      }else {
          List<String> selectionList = Arrays.asList(selections.split(","));
          iostReceivingNoteList = queryList.stream().filter(item -> selectionList.contains(item.getId())).collect(Collectors.toList());
      }

      // Step.3 组装pageList
      List<IostReceivingNotePage> pageList = new ArrayList<IostReceivingNotePage>();
      for (IostReceivingNote main : iostReceivingNoteList) {
          IostReceivingNotePage vo = new IostReceivingNotePage();
          BeanUtils.copyProperties(main, vo);
          List<IostReceivingNoteList> iostReceivingNoteListList = iostReceivingNoteListService.selectByMainId(main.getId());
          vo.setIostReceivingNoteListList(iostReceivingNoteListList);
          pageList.add(vo);
      }

      // Step.4 AutoPoi 导出Excel
      ModelAndView mv = new ModelAndView(new JeecgEntityExcelView());
      mv.addObject(NormalExcelConstants.FILE_NAME, "收费单列表");
      mv.addObject(NormalExcelConstants.CLASS, IostReceivingNotePage.class);
      mv.addObject(NormalExcelConstants.PARAMS, new ExportParams("收费单数据", "导出人:"+sysUser.getRealname(), "收费单"));
      mv.addObject(NormalExcelConstants.DATA_LIST, pageList);
      return mv;
    }

    /**
    * 通过excel导入数据
    *
    * @param request
    * @param response
    * @return
    */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
      MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
      Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
      for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
          MultipartFile file = entity.getValue();// 获取上传文件对象
          ImportParams params = new ImportParams();
          params.setTitleRows(2);
          params.setHeadRows(1);
          params.setNeedSave(true);
          try {
              List<IostReceivingNotePage> list = ExcelImportUtil.importExcel(file.getInputStream(), IostReceivingNotePage.class, params);
              for (IostReceivingNotePage page : list) {
                  IostReceivingNote po = new IostReceivingNote();
                  BeanUtils.copyProperties(page, po);
                  iostReceivingNoteService.saveMain(po, page.getIostReceivingNoteListList());
              }
              return Result.OK("文件导入成功！数据行数:" + list.size());
          } catch (Exception e) {
              log.error(e.getMessage(),e);
              return Result.error("文件导入失败:"+e.getMessage());
          } finally {
              try {
                  file.getInputStream().close();
              } catch (IOException e) {
                  e.printStackTrace();
              }
          }
      }
      return Result.OK("文件导入失败！");
    }

}
