package org.jeecg.modules.iost.basedata.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @Description: delivery note
 * @Author: jeecg-boot
 * @Date:   2020-12-29
 * @Version: V1.0
 */
@ApiModel(value="iost_delivery_note对象", description="delivery note")
@Data
@TableName("iost_delivery_note")
public class IostDeliveryNote implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private java.lang.String id;
	/**创建人*/
    @ApiModelProperty(value = "创建人")
    private java.lang.String createBy;
	/**更新人*/
    @ApiModelProperty(value = "更新人")
    private java.lang.String updateBy;
	/**更新日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private java.util.Date updateTime;
	/**所属部门*/
    @ApiModelProperty(value = "所属部门")
    private java.lang.String sysOrgCode;
	/**Contact Name*/
	@Excel(name = "Contact Name", width = 15)
    @ApiModelProperty(value = "Contact Name")
    private java.lang.String contactName;
	/**Date*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    @ApiModelProperty(value = "Date")
    private java.util.Date createTime;
	/**Phone No.*/
	@Excel(name = "Phone No.", width = 15)
    @ApiModelProperty(value = "Phone No.")
    private java.lang.String phoneNo;
	/**Reference*/
	@Excel(name = "Reference", width = 15)
    @ApiModelProperty(value = "Reference")
    private java.lang.String reference;
	/**Company*/
	@Excel(name = "Company", width = 15)
    @ApiModelProperty(value = "Company")
    private java.lang.String company;
	/**Address*/
	@Excel(name = "Address", width = 15)
    @ApiModelProperty(value = "Address")
    private java.lang.String address;
	/**出库单Id*/
	@Excel(name = "出库单Id", width = 15)
    @ApiModelProperty(value = "出库单Id")
    private java.lang.String deliveryRecordId;
}
